/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent.profiler;

import java.util.SortedSet;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicReference;
import org.snapscript.common.thread.ThreadBuilder;
import org.snapscript.studio.agent.event.ProcessEventChannel;
import org.snapscript.studio.agent.event.ProfileEvent;
import org.snapscript.studio.agent.profiler.ProfileResult;
import org.snapscript.studio.agent.profiler.TraceProfiler;

public class ProfileResultUpdater
implements Runnable {
    private final AtomicReference<String> reference = new AtomicReference();
    private final ProcessEventChannel channel;
    private final TraceProfiler profiler;
    private final ThreadFactory factory = new ThreadBuilder();

    public ProfileResultUpdater(TraceProfiler profiler, ProcessEventChannel channel) {
        this.profiler = profiler;
        this.channel = channel;
    }

    public void start(String process) {
        if (this.reference.compareAndSet(null, process)) {
            Thread thread = this.factory.newThread(this);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long delay = 1000L;
        while (true) {
            String process = this.reference.get();
            try {
                Thread.sleep(delay);
                SortedSet<ProfileResult> results = this.profiler.lines(2000);
                ProfileEvent event = new ProfileEvent.Builder(process).withResults(results).build();
                this.channel.send(event);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            finally {
                delay = 5000L;
                continue;
            }
            break;
        }
    }
}

