/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent.profiler;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import org.snapscript.core.module.Path;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.trace.Trace;
import org.snapscript.studio.agent.debug.TraceAdapter;
import org.snapscript.studio.agent.profiler.ProfileResult;
import org.snapscript.studio.agent.profiler.ResourceProfiler;

public class TraceProfiler
extends TraceAdapter {
    private final Map<String, ResourceProfiler> profilers = new ConcurrentHashMap<String, ResourceProfiler>();
    private final Set<String> resources = new CopyOnWriteArraySet<String>();

    public SortedSet<ProfileResult> lines(int size) {
        TreeSet<ProfileResult> results = new TreeSet<ProfileResult>();
        TreeSet<ProfileResult> reduced = new TreeSet<ProfileResult>();
        for (String resource : this.resources) {
            ResourceProfiler profiler = this.profilers.get(resource);
            if (profiler == null) continue;
            profiler.collect(results, size);
        }
        Iterator iterator = results.iterator();
        while (iterator.hasNext() && size-- > 0) {
            long duration;
            ProfileResult result = (ProfileResult)iterator.next();
            if (result == null || (duration = result.getTime()) <= 0L) continue;
            reduced.add(result);
        }
        return reduced;
    }

    @Override
    public void traceBefore(Scope scope, Trace trace) {
        Path path = trace.getPath();
        String resource = path.getPath();
        ResourceProfiler profiler = this.profilers.get(resource);
        int line = trace.getLine();
        if (profiler == null) {
            String local = resource;
            if (!local.endsWith(".snap")) {
                local = local.replace('.', '/');
                local = local + ".snap";
            }
            if (!local.startsWith("/")) {
                local = "/" + local;
            }
            if (this.resources.add(local)) {
                profiler = new ResourceProfiler(local);
                this.profilers.put(resource, profiler);
                this.resources.add(resource);
            }
        }
        if (profiler != null) {
            profiler.enter(line);
        }
    }

    @Override
    public void traceAfter(Scope scope, Trace trace) {
        Path path = trace.getPath();
        String resource = path.getPath();
        ResourceProfiler profiler = this.profilers.get(resource);
        int line = trace.getLine();
        if (profiler != null) {
            profiler.exit(line);
        }
    }
}

