/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent.task;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.snapscript.studio.agent.client.ConnectionListener;
import org.snapscript.studio.agent.event.ProcessEventChannel;
import org.snapscript.studio.agent.event.ProcessEventType;
import org.snapscript.studio.agent.task.ExceptionBuilder;
import org.snapscript.studio.agent.task.ProcessOutputStream;

public class ConsoleConnector
implements ConnectionListener {
    private final ProcessOutputStream errorAdapter;
    private final ProcessOutputStream outputAdapter;
    private final PrintStream originalOutput;
    private final PrintStream originalError;
    private final PrintStream output;
    private final PrintStream error;

    public ConsoleConnector(ProcessEventChannel channel, String process) throws Exception {
        this.errorAdapter = new ProcessOutputStream(ProcessEventType.WRITE_ERROR, channel, System.err, process);
        this.outputAdapter = new ProcessOutputStream(ProcessEventType.WRITE_OUTPUT, channel, System.out, process);
        this.output = new ConsoleStream(this.outputAdapter, System.out, true, "UTF-8");
        this.error = new ConsoleStream(this.errorAdapter, System.err, true, "UTF-8");
        this.originalError = System.err;
        this.originalOutput = System.out;
    }

    public void connect() {
        try {
            System.setOut(this.output);
            System.setErr(this.error);
        }
        catch (Exception e) {
            System.err.println(ExceptionBuilder.build(e));
        }
    }

    @Override
    public void onClose() {
        try {
            System.setOut(this.originalOutput);
            System.setErr(this.originalError);
        }
        catch (Exception e) {
            System.err.println(ExceptionBuilder.build(e));
        }
    }

    private static class ConsoleStream
    extends PrintStream {
        private final PrintStream stream;

        public ConsoleStream(OutputStream out, PrintStream stream, boolean autoFlush, String encoding) throws UnsupportedEncodingException {
            super(out, autoFlush, encoding);
            this.stream = stream;
        }

        @Override
        public void close() {
            this.stream.close();
        }
    }
}

