/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent.task;

import java.util.List;
import java.util.concurrent.ThreadFactory;
import org.snapscript.common.thread.ThreadBuilder;
import org.snapscript.core.scope.Model;
import org.snapscript.studio.agent.ProcessContext;
import org.snapscript.studio.agent.ProcessMode;
import org.snapscript.studio.agent.ProcessModel;
import org.snapscript.studio.agent.client.ConnectionChecker;
import org.snapscript.studio.agent.core.ClassPathUpdater;
import org.snapscript.studio.agent.core.ExecuteData;
import org.snapscript.studio.agent.core.ExecuteLatch;
import org.snapscript.studio.agent.event.ProcessEventChannel;
import org.snapscript.studio.agent.log.TraceLogger;
import org.snapscript.studio.agent.task.ConsoleConnector;
import org.snapscript.studio.agent.task.ProcessTask;
import org.snapscript.studio.agent.task.ProgressReporter;

public class ProcessExecutor {
    private final ConnectionChecker checker;
    private final ThreadFactory factory = new ThreadBuilder();
    private final ProcessContext context;
    private final TraceLogger logger;
    private final ProcessMode mode;
    private final Model model;
    private final String[] empty = new String[0];

    public ProcessExecutor(ProcessContext context, ConnectionChecker checker, TraceLogger logger, ProcessMode mode, Model model) {
        this.checker = checker;
        this.logger = logger;
        this.context = context;
        this.model = model;
        this.mode = mode;
    }

    public void beginExecute(ProcessEventChannel channel, String project, String resource, String dependencies, List<String> arguments, boolean debug) {
        ExecuteLatch latch = this.context.getLatch();
        String process = this.context.getProcess();
        try {
            if (resource != null) {
                ProcessModel overrides = new ProcessModel(this.model);
                ExecuteData data = new ExecuteData(process, project, resource, dependencies, debug);
                ConsoleConnector connector = new ConsoleConnector(channel, process);
                ProcessTask harness = new ProcessTask(this.context, channel, this.mode, overrides, project, resource, debug);
                if (latch.start(data)) {
                    Thread thread = this.factory.newThread(harness);
                    ClassLoader loader = ClassPathUpdater.updateClassPath(dependencies);
                    String[] array = arguments.toArray(this.empty);
                    overrides.addAttribute("args", array);
                    overrides.addAttribute("arguments", array);
                    if (loader == null) {
                        this.logger.info("Could not update dependencies");
                    }
                    this.checker.register(connector);
                    connector.connect();
                    thread.start();
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not execute '" + resource + "' from project '" + project + "'", e);
        }
    }

    public void attachProcess(ProcessEventChannel channel, String project, String resource) {
        ExecuteLatch latch = this.context.getLatch();
        String process = this.context.getProcess();
        try {
            if (resource != null) {
                ExecuteData data = new ExecuteData(process, project, resource, null, true);
                ProgressReporter reporter = new ProgressReporter(this.context, channel, project, resource, true);
                ConsoleConnector connector = new ConsoleConnector(channel, process);
                if (latch.start(data)) {
                    reporter.reportExecuting();
                    this.checker.register(connector);
                    connector.connect();
                }
            }
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not execute '" + resource + "' from project '" + project + "'", e);
        }
    }
}

