/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent.task;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.snapscript.compile.Executable;
import org.snapscript.compile.ResourceCompiler;
import org.snapscript.compile.verify.VerifyError;
import org.snapscript.compile.verify.VerifyException;
import org.snapscript.core.scope.Model;
import org.snapscript.studio.agent.ProcessContext;
import org.snapscript.studio.agent.ProcessMode;
import org.snapscript.studio.agent.event.ProcessEventChannel;
import org.snapscript.studio.agent.profiler.ProfileResultUpdater;
import org.snapscript.studio.agent.profiler.TraceProfiler;
import org.snapscript.studio.agent.task.ConsoleFlusher;
import org.snapscript.studio.agent.task.ProgressReporter;

public class ProcessTask
implements Runnable {
    private final ProgressReporter reporter;
    private final ProcessEventChannel client;
    private final ProcessContext context;
    private final ProcessMode mode;
    private final String resource;
    private final Model model;

    public ProcessTask(ProcessContext context, ProcessEventChannel client, ProcessMode mode, Model model, String project, String resource, boolean debug) {
        this.reporter = new ProgressReporter(context, client, project, resource, debug);
        this.client = client;
        this.resource = resource;
        this.context = context;
        this.model = model;
        this.mode = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TraceProfiler profiler = this.context.getProfiler();
        ResourceCompiler compiler = this.context.getCompiler();
        String process = this.context.getProcess();
        long start = System.nanoTime();
        try {
            ProfileResultUpdater updater = new ProfileResultUpdater(profiler, this.client);
            this.reporter.reportCompiling();
            Executable executable = compiler.compile(this.resource);
            this.reporter.reportExecuting();
            try {
                updater.start(process);
                executable.execute(this.model);
            }
            catch (VerifyException e) {
                List<VerifyError> errors = e.getErrors();
                this.reporter.reportError(errors);
            }
            catch (Throwable cause) {
                ConsoleFlusher.flushError(cause);
                try {
                    if (this.mode.isTerminateRequired()) {
                        this.reporter.reportTerminating();
                        this.reporter.reportProfile();
                    }
                    ConsoleFlusher.flush();
                }
                catch (Exception cause2) {
                    ConsoleFlusher.flushError(cause2);
                }
            }
            finally {
                try {
                    if (this.mode.isTerminateRequired()) {
                        this.reporter.reportTerminating();
                        this.reporter.reportProfile();
                    }
                    ConsoleFlusher.flush();
                }
                catch (Exception cause) {
                    ConsoleFlusher.flushError(cause);
                }
            }
        }
        catch (Exception cause) {
            ConsoleFlusher.flushError(cause);
        }
        finally {
            if (this.mode.isTerminateRequired()) {
                long finish = System.nanoTime();
                long duration = TimeUnit.NANOSECONDS.toMillis(finish - start);
                this.reporter.reportFinished(duration);
            }
        }
    }
}

