/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent.task;

import java.util.List;
import java.util.SortedSet;
import org.snapscript.compile.verify.VerifyError;
import org.snapscript.core.trace.Trace;
import org.snapscript.studio.agent.ProcessContext;
import org.snapscript.studio.agent.ProcessMode;
import org.snapscript.studio.agent.core.ExecuteData;
import org.snapscript.studio.agent.core.ExecuteLatch;
import org.snapscript.studio.agent.core.ExecuteState;
import org.snapscript.studio.agent.core.ExecuteStatus;
import org.snapscript.studio.agent.core.TerminateHandler;
import org.snapscript.studio.agent.event.BeginEvent;
import org.snapscript.studio.agent.event.ExitEvent;
import org.snapscript.studio.agent.event.PongEvent;
import org.snapscript.studio.agent.event.ProcessEventChannel;
import org.snapscript.studio.agent.event.ProfileEvent;
import org.snapscript.studio.agent.event.ProgressEvent;
import org.snapscript.studio.agent.event.ScriptErrorEvent;
import org.snapscript.studio.agent.profiler.ProfileResult;
import org.snapscript.studio.agent.profiler.TraceProfiler;
import org.snapscript.studio.agent.task.ConsoleFlusher;

public class ProgressReporter {
    private final ProcessEventChannel client;
    private final ProcessContext context;
    private final String project;
    private final String resource;
    private final boolean debug;

    public ProgressReporter(ProcessContext context, ProcessEventChannel client, String project, String resource, boolean debug) {
        this.context = context;
        this.client = client;
        this.project = project;
        this.resource = resource;
        this.debug = debug;
    }

    public void reportCompiling() {
        ExecuteLatch latch = this.context.getLatch();
        ExecuteState state = latch.getState();
        ExecuteData data = state.getData();
        String process = state.getProcess();
        String system = state.getSystem();
        String project = data.getProject();
        long duration = latch.update(ExecuteStatus.COMPILING);
        if (duration >= 0L) {
            try {
                ProgressEvent event = (ProgressEvent)((PongEvent.Builder)((PongEvent.Builder)((PongEvent.Builder)((PongEvent.Builder)((PongEvent.Builder)((PongEvent.Builder)((PongEvent.Builder)new ProgressEvent.Builder(process).withSystem(system)).withProject(project)).withResource(this.resource)).withStatus(ExecuteStatus.COMPILING)).withTotalMemory(Runtime.getRuntime().totalMemory())).withUsedMemory(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory())).withThreads(Thread.getAllStackTraces().size())).build();
                this.client.send(event);
            }
            catch (Exception e) {
                ConsoleFlusher.flushError(e);
            }
        }
    }

    public void reportExecuting() {
        ExecuteLatch latch = this.context.getLatch();
        ExecuteState state = latch.getState();
        ExecuteData data = state.getData();
        String process = state.getProcess();
        String system = state.getSystem();
        String project = data.getProject();
        long duration = latch.update(this.debug ? ExecuteStatus.DEBUGGING : ExecuteStatus.RUNNING);
        if (duration >= 0L) {
            try {
                BeginEvent event = new BeginEvent.Builder(process).withMode(this.context.getMode()).withDuration(duration).withSystem(system).withProject(project).withResource(this.resource).withStatus(this.debug ? ExecuteStatus.DEBUGGING : ExecuteStatus.RUNNING).withTotalMemory(Runtime.getRuntime().totalMemory()).withUsedMemory(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()).withThreads(Thread.getAllStackTraces().size()).build();
                this.client.send(event);
            }
            catch (Exception e) {
                ConsoleFlusher.flushError(e);
            }
        }
    }

    public void reportError(List<VerifyError> errors) {
        String process = this.context.getProcess();
        for (VerifyError error : errors) {
            Exception cause = error.getCause();
            Trace trace = error.getTrace();
            String description = cause.getMessage();
            String path = trace.getPath().toString();
            int line = trace.getLine();
            try {
                ScriptErrorEvent event = new ScriptErrorEvent.Builder(process).withDescription(description).withResource(path).withLine(line).build();
                this.client.send(event);
            }
            catch (Exception e) {
                ConsoleFlusher.flushError(e);
            }
        }
    }

    public void reportTerminating() {
        ExecuteLatch latch = this.context.getLatch();
        ExecuteState state = latch.getState();
        String process = state.getProcess();
        String system = state.getSystem();
        long duration = latch.update(ExecuteStatus.TERMINATING);
        if (duration >= 0L) {
            try {
                ProgressEvent event = (ProgressEvent)((PongEvent.Builder)((PongEvent.Builder)((PongEvent.Builder)((PongEvent.Builder)((PongEvent.Builder)((PongEvent.Builder)((PongEvent.Builder)new ProgressEvent.Builder(process).withSystem(system)).withProject(this.project)).withResource(this.resource)).withStatus(ExecuteStatus.TERMINATING)).withTotalMemory(Runtime.getRuntime().totalMemory())).withUsedMemory(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory())).withThreads(Thread.getAllStackTraces().size())).build();
                this.client.send(event);
            }
            catch (Exception e) {
                ConsoleFlusher.flushError(e);
            }
        }
    }

    public void reportProfile() {
        ExecuteLatch latch = this.context.getLatch();
        ExecuteState state = latch.getState();
        TraceProfiler profiler = this.context.getProfiler();
        SortedSet<ProfileResult> lines = profiler.lines(200);
        String process = state.getProcess();
        try {
            ProfileEvent profile = new ProfileEvent.Builder(process).withResults(lines).build();
            this.client.send(profile);
        }
        catch (Exception e) {
            ConsoleFlusher.flushError(e);
        }
    }

    public void reportFinished(long totalTime) {
        ProcessMode mode = this.context.getMode();
        ExecuteLatch latch = this.context.getLatch();
        String process = this.context.getProcess();
        long duration = latch.update(ExecuteStatus.FINISHED);
        if (duration >= 0L) {
            try {
                ExitEvent event = new ExitEvent.Builder(process).withDuration(totalTime).withMode(this.context.getMode()).build();
                this.client.send(event);
            }
            catch (Exception e) {
                ConsoleFlusher.flushError(e);
            }
        }
        if (mode.isTerminateRequired()) {
            TerminateHandler.terminate("Task has finished executing");
        }
    }
}

