/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.studio.agent.worker;

import java.net.URI;
import org.snapscript.studio.agent.ProcessMode;
import org.snapscript.studio.agent.cli.CommandLine;
import org.snapscript.studio.agent.log.LogLevel;
import org.snapscript.studio.agent.worker.WorkerOption;

public class WorkerCommandLine {
    public static final String DOWNLOAD_PATH = "/download";
    public static final String CLASSES_PATH = "/classes";
    private final CommandLine line;

    public WorkerCommandLine(CommandLine line) {
        this.line = line;
    }

    public String getName() {
        return (String)this.line.getValue(WorkerOption.NAME.name);
    }

    public LogLevel getLogLevel() {
        return LogLevel.resolveLevel((String)this.line.getValue(WorkerOption.LEVEL.name));
    }

    public ProcessMode getMode() {
        return ProcessMode.resolveMode((String)this.line.getValue(WorkerOption.MODE.name));
    }

    public String getAddress() {
        return "http://" + this.line.getValue(WorkerOption.HOST.name) + ":" + this.line.getValue(WorkerOption.PORT.name);
    }

    public URI getDownloadURL() {
        return URI.create(this.getAddress() + DOWNLOAD_PATH);
    }

    public URI getClassURL() {
        return URI.create(this.getAddress() + CLASSES_PATH);
    }

    public String getSystem() {
        return System.getProperty("os.name", "unknown");
    }

    public String[] getArguments() {
        return this.line.getArguments();
    }
}

