/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree;

import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;
import org.snapscript.core.variable.Value;
import org.snapscript.tree.Argument;

public class ArgumentList {
    private final Argument[] list;
    private final Object[] empty = new Object[0];
    private final Type[] none = new Type[0];

    public ArgumentList(Argument ... list) {
        this.list = list;
    }

    public int define(Scope scope) throws Exception {
        for (int i = 0; i < this.list.length; ++i) {
            this.list[i].define(scope);
        }
        return this.list.length;
    }

    public Type[] compile(Scope scope, Constraint left) throws Exception {
        if (this.list.length > 0) {
            return this.compile(scope, this.none);
        }
        return this.none;
    }

    public Type[] compile(Scope scope, Type ... prefix) throws Exception {
        int i;
        Type[] values = new Type[this.list.length + prefix.length];
        for (i = 0; i < this.list.length; ++i) {
            Type type;
            Constraint result = this.list[i].compile(scope, null);
            values[i + prefix.length] = type = result.getType(scope);
        }
        for (i = 0; i < prefix.length; ++i) {
            values[i] = prefix[i];
        }
        return values;
    }

    public Object[] create(Scope scope) throws Exception {
        if (this.list.length > 0) {
            return this.create(scope, this.empty);
        }
        return this.empty;
    }

    public Object[] create(Scope scope, Object ... prefix) throws Exception {
        int i;
        Object[] values = new Object[this.list.length + prefix.length];
        for (i = 0; i < this.list.length; ++i) {
            Value reference = this.list[i].evaluate(scope, null);
            Object result = reference.getValue();
            values[i + prefix.length] = result;
        }
        for (i = 0; i < prefix.length; ++i) {
            values[i] = prefix[i];
        }
        return values;
    }
}

