/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree;

import org.snapscript.core.Compilation;
import org.snapscript.core.Context;
import org.snapscript.core.Evaluation;
import org.snapscript.core.Execution;
import org.snapscript.core.Statement;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.ErrorHandler;
import org.snapscript.core.module.Module;
import org.snapscript.core.module.Path;
import org.snapscript.core.result.Result;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.trace.Trace;
import org.snapscript.core.trace.TraceInterceptor;
import org.snapscript.core.trace.TraceStatement;
import org.snapscript.core.variable.Value;
import org.snapscript.tree.AssertException;

public class AssertStatement
implements Compilation {
    private final Statement assertion;

    public AssertStatement(Evaluation evaluation) {
        this.assertion = new CompileResult(evaluation);
    }

    @Override
    public Statement compile(Module module, Path path, int line) throws Exception {
        Context context = module.getContext();
        ErrorHandler handler = context.getHandler();
        TraceInterceptor interceptor = context.getInterceptor();
        Trace trace = Trace.getNormal(module, path, line);
        return new TraceStatement(interceptor, handler, this.assertion, trace);
    }

    private static class CompileExecution
    extends Execution {
        private final Evaluation evaluation;

        public CompileExecution(Evaluation evaluation) {
            this.evaluation = evaluation;
        }

        @Override
        public Result execute(Scope scope) throws Exception {
            Value value = this.evaluation.evaluate(scope, null);
            Object object = value.getValue();
            if (!Boolean.TRUE.equals(object)) {
                throw new AssertException("Assertion failed");
            }
            return Result.NORMAL;
        }
    }

    private static class CompileResult
    extends Statement {
        private final Evaluation evaluation;

        public CompileResult(Evaluation evaluation) {
            this.evaluation = evaluation;
        }

        @Override
        public boolean define(Scope scope) throws Exception {
            this.evaluation.define(scope);
            return true;
        }

        @Override
        public Execution compile(Scope scope, Constraint returns) throws Exception {
            this.evaluation.compile(scope, null);
            return new CompileExecution(this.evaluation);
        }
    }
}

