/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree;

import java.util.concurrent.atomic.AtomicInteger;
import org.snapscript.core.Execution;
import org.snapscript.core.Statement;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.convert.TypeInspector;
import org.snapscript.core.error.ErrorCauseExtractor;
import org.snapscript.core.function.Parameter;
import org.snapscript.core.result.Result;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.scope.index.Index;
import org.snapscript.core.scope.index.Local;
import org.snapscript.core.scope.index.Table;
import org.snapscript.core.type.Type;
import org.snapscript.tree.CatchBlock;
import org.snapscript.tree.function.ParameterDeclaration;

public class CatchBlockList {
    private final ErrorCauseExtractor extractor = new ErrorCauseExtractor();
    private final TypeInspector inspector = new TypeInspector();
    private final AtomicInteger offset = new AtomicInteger(-1);
    private final CatchBlock[] blocks;
    private final Execution[] list;

    public CatchBlockList(CatchBlock ... blocks) {
        this.list = new Execution[blocks.length];
        this.blocks = blocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result define(Scope scope) throws Exception {
        for (int i = 0; i < this.blocks.length; ++i) {
            CatchBlock block = this.blocks[i];
            Statement statement = block.getStatement();
            if (statement == null) continue;
            Index index = scope.getIndex();
            int size = index.size();
            try {
                ParameterDeclaration declaration = block.getDeclaration();
                Parameter parameter = declaration.get(scope);
                String name = parameter.getName();
                int value = index.index(name);
                this.offset.set(value);
                statement.define(scope);
                continue;
            }
            finally {
                index.reset(size);
            }
        }
        return Result.NORMAL;
    }

    public Result compile(Scope scope) throws Exception {
        for (int i = 0; i < this.blocks.length; ++i) {
            CatchBlock block = this.blocks[i];
            Statement statement = block.getStatement();
            if (statement == null) continue;
            ParameterDeclaration declaration = block.getDeclaration();
            Parameter parameter = declaration.get(scope);
            Constraint constraint = parameter.getConstraint();
            String name = parameter.getName();
            Table table = scope.getTable();
            Local local = Local.getConstant(null, name, constraint);
            int index = this.offset.get();
            table.addLocal(index, local);
            this.list[i] = statement.compile(scope, null);
        }
        return Result.NORMAL;
    }

    public Result execute(Scope scope, Result result) throws Exception {
        Object data = result.getValue();
        for (int i = 0; i < this.blocks.length; ++i) {
            Object cause;
            CatchBlock block = this.blocks[i];
            ParameterDeclaration declaration = block.getDeclaration();
            Parameter parameter = declaration.get(scope);
            Constraint constraint = parameter.getConstraint();
            Type type = constraint.getType(scope);
            String name = parameter.getName();
            if (data == null || !this.inspector.isCompatible(type, cause = this.extractor.extract(scope, data))) continue;
            Table table = scope.getTable();
            Local local = Local.getConstant(cause, name);
            int index = this.offset.get();
            table.addLocal(index, local);
            return this.list[i].execute(scope);
        }
        return result;
    }
}

