/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree;

import java.util.concurrent.atomic.AtomicInteger;
import org.snapscript.core.Evaluation;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.scope.index.Index;
import org.snapscript.core.scope.index.Local;
import org.snapscript.core.scope.index.Table;
import org.snapscript.core.variable.Value;
import org.snapscript.tree.DeclarationAllocator;
import org.snapscript.tree.NameReference;
import org.snapscript.tree.literal.TextLiteral;

public class Declaration {
    private final DeclarationAllocator allocator;
    private final NameReference reference;
    private final AtomicInteger offset;
    private final Evaluation value;

    public Declaration(TextLiteral identifier) {
        this(identifier, null, null);
    }

    public Declaration(TextLiteral identifier, Constraint constraint) {
        this(identifier, constraint, null);
    }

    public Declaration(TextLiteral identifier, Evaluation value) {
        this(identifier, null, value);
    }

    public Declaration(TextLiteral identifier, Constraint constraint, Evaluation value) {
        this.allocator = new DeclarationAllocator(constraint, value);
        this.reference = new NameReference(identifier);
        this.offset = new AtomicInteger(-1);
        this.value = value;
    }

    public int define(Scope scope, int modifiers) throws Exception {
        String name = this.reference.getName(scope);
        if (this.value != null) {
            this.value.define(scope);
        }
        Index index = scope.getIndex();
        int depth = index.index(name);
        this.offset.set(depth);
        return depth;
    }

    public Value compile(Scope scope, int modifiers) throws Exception {
        String name = this.reference.getName(scope);
        Local local = (Local)this.allocator.compile(scope, name, modifiers);
        Table table = scope.getTable();
        int depth = this.offset.get();
        try {
            table.addLocal(depth, local);
        }
        catch (Exception e) {
            throw new InternalStateException("Declaration of variable '" + name + "' failed", e);
        }
        return local;
    }

    public Value declare(Scope scope, int modifiers) throws Exception {
        String name = this.reference.getName(scope);
        Local local = (Local)this.allocator.allocate(scope, name, modifiers);
        Table table = scope.getTable();
        int depth = this.offset.get();
        try {
            table.addLocal(depth, local);
        }
        catch (Exception e) {
            throw new InternalStateException("Declaration of variable '" + name + "' failed", e);
        }
        return local;
    }
}

