/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree;

import org.snapscript.core.Evaluation;
import org.snapscript.core.ModifierType;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.constraint.DeclarationConstraint;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.scope.index.Local;
import org.snapscript.core.type.Type;
import org.snapscript.core.variable.Value;
import org.snapscript.tree.DeclarationConverter;

public class DeclarationAllocator {
    private final DeclarationConstraint constraint;
    private final DeclarationConverter converter;
    private final Evaluation expression;

    public DeclarationAllocator(Constraint constraint, Evaluation expression) {
        this.constraint = new DeclarationConstraint(constraint);
        this.converter = new DeclarationConverter();
        this.expression = expression;
    }

    public <T extends Value> T compile(Scope scope, String name, int modifiers) throws Exception {
        Type type = this.constraint.getType(scope);
        DeclarationConstraint declare = this.constraint.getConstraint(scope, modifiers);
        if (this.expression != null) {
            Constraint object = this.expression.compile(scope, null);
            Type real = object.getType(scope);
            if (real != null) {
                object = this.converter.compile(scope, real, this.constraint, name);
            }
            return this.assign(scope, name, null, declare, modifiers);
        }
        return this.declare(scope, name, declare, modifiers);
    }

    public <T extends Value> T allocate(Scope scope, String name, int modifiers) throws Exception {
        Type type = this.constraint.getType(scope);
        Object object = null;
        if (this.expression != null) {
            Value value = this.expression.evaluate(scope, null);
            Object original = value.getValue();
            object = type != null ? this.converter.convert(scope, original, this.constraint, name) : (Object)original;
            return this.assign(scope, name, object, this.constraint, modifiers);
        }
        return this.declare(scope, name, this.constraint, modifiers);
    }

    protected <T extends Value> T declare(Scope scope, String name, Constraint type, int modifiers) throws Exception {
        if (ModifierType.isConstant(modifiers)) {
            return (T)Local.getConstant(null, name, type);
        }
        return (T)Local.getReference(null, name, type);
    }

    protected <T extends Value> T assign(Scope scope, String name, Object value, Constraint type, int modifiers) throws Exception {
        if (ModifierType.isConstant(modifiers)) {
            return (T)Local.getConstant(value, name, type);
        }
        return (T)Local.getReference(value, name, type);
    }
}

