/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree;

import org.snapscript.parse.StringToken;
import org.snapscript.tree.Qualifier;

public class FullQualifier
implements Qualifier {
    private final StringToken[] tokens;
    private final int count;

    public FullQualifier(StringToken ... tokens) {
        this.count = tokens.length;
        this.tokens = tokens;
    }

    @Override
    public String getQualifier() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.count; ++i) {
            String value = this.tokens[i].getValue();
            if (i > 0) {
                builder.append(".");
            }
            builder.append(value);
        }
        return builder.toString();
    }

    @Override
    public String getLocation() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.count - 1; ++i) {
            String value = this.tokens[i].getValue();
            char first = value.charAt(0);
            if (first >= 'A' && first <= 'Z') {
                return builder.toString();
            }
            if (i > 0) {
                builder.append(".");
            }
            builder.append(value);
        }
        return builder.toString();
    }

    @Override
    public String getTarget() {
        StringBuilder builder = new StringBuilder();
        for (int i = 1; i < this.count; ++i) {
            String value = this.tokens[i].getValue();
            char first = value.charAt(0);
            if (first < 'A' || first > 'Z') continue;
            builder.append(value);
            while (++i < this.count) {
                value = this.tokens[i].getValue();
                first = value.charAt(0);
                if (first < 'A' || first > 'Z') {
                    return builder.toString();
                }
                builder.append("$");
                builder.append(value);
            }
        }
        return builder.toString();
    }

    @Override
    public String getName() {
        if (this.count > 0) {
            StringToken token = this.tokens[this.count - 1];
            String value = token.getValue();
            return value;
        }
        return null;
    }
}

