/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree;

import org.snapscript.core.Context;
import org.snapscript.core.Evaluation;
import org.snapscript.core.Execution;
import org.snapscript.core.NameFormatter;
import org.snapscript.core.NoStatement;
import org.snapscript.core.Statement;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.link.ImportManager;
import org.snapscript.core.link.Package;
import org.snapscript.core.link.PackageDefinition;
import org.snapscript.core.module.Module;
import org.snapscript.core.module.Path;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.TypeLoader;
import org.snapscript.core.variable.Value;
import org.snapscript.tree.Qualifier;

public class ImportBuilder {
    private final Qualifier qualifier;
    private final Evaluation alias;

    public ImportBuilder(Qualifier qualifier, Evaluation alias) {
        this.qualifier = qualifier;
        this.alias = alias;
    }

    public Statement create(Module module, Path path, int line) throws Exception {
        Package library;
        Context context = module.getContext();
        TypeLoader loader = context.getLoader();
        String location = this.qualifier.getLocation();
        String target = this.qualifier.getTarget();
        String name = this.qualifier.getName();
        if (target == null && (library = loader.importPackage(location)) != null) {
            return new CompileResult(library, path, location, null, name);
        }
        library = loader.importType(location, target);
        if (library != null) {
            if (this.alias != null) {
                Scope scope = module.getScope();
                Value value = this.alias.evaluate(scope, null);
                String alias = value.getString();
                return new CompileResult(library, path, location, target, alias);
            }
            return new CompileResult(library, path, location, target, target, name);
        }
        return new NoStatement();
    }

    private static class CompileResult
    extends Statement {
        private PackageDefinition definition;
        private NameFormatter formatter = new NameFormatter();
        private Statement statement;
        private Package library;
        private Path path;
        private String location;
        private String target;
        private String[] alias;

        public CompileResult(Package library, Path path, String location, String target, String ... alias) {
            this.location = location;
            this.library = library;
            this.target = target;
            this.alias = alias;
            this.path = path;
        }

        @Override
        public void create(Scope scope) throws Exception {
            if (this.library == null) {
                throw new InternalStateException("Import '" + this.location + "' was not loaded");
            }
            if (this.definition == null) {
                this.definition = this.process(scope);
            }
        }

        @Override
        public boolean define(Scope scope) throws Exception {
            if (this.definition == null) {
                throw new InternalStateException("Import '" + this.location + "' was not defined");
            }
            if (this.statement == null) {
                this.statement = this.definition.define(scope, this.path);
            }
            return true;
        }

        @Override
        public Execution compile(Scope scope, Constraint returns) throws Exception {
            if (this.statement == null) {
                throw new InternalStateException("Import '" + this.location + "' was not compiled");
            }
            return this.statement.compile(scope, returns);
        }

        private PackageDefinition process(Scope scope) throws Exception {
            Module module = scope.getModule();
            ImportManager manager = module.getManager();
            String type = this.formatter.formatFullName(this.location, this.target);
            if (this.target == null) {
                manager.addImport(this.location);
            } else if (this.alias != null) {
                for (String name : this.alias) {
                    if (name == null) continue;
                    manager.addImport(type, name);
                }
            } else {
                manager.addImport(type, this.target);
            }
            return this.library.create(scope);
        }
    }
}

