/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree;

import org.snapscript.core.Compilation;
import org.snapscript.core.Context;
import org.snapscript.core.Statement;
import org.snapscript.core.link.ExceptionStatement;
import org.snapscript.core.module.Module;
import org.snapscript.core.module.Path;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.trace.Trace;
import org.snapscript.core.trace.TraceInterceptor;
import org.snapscript.tree.ImportBuilder;
import org.snapscript.tree.Qualifier;
import org.snapscript.tree.StatementBlock;

public class ImportList
implements Compilation {
    private final Statement[] statements;
    private final Qualifier qualifier;
    private final Qualifier[] names;

    public ImportList(Qualifier qualifier, Qualifier ... names) {
        this.statements = new Statement[names.length];
        this.qualifier = qualifier;
        this.names = names;
    }

    @Override
    public Statement compile(Module module, Path path, int line) throws Exception {
        Scope scope = module.getScope();
        Context context = module.getContext();
        TraceInterceptor interceptor = context.getInterceptor();
        Trace trace = Trace.getImport(module, path, line);
        String prefix = this.qualifier.getQualifier();
        for (int i = 0; i < this.names.length; ++i) {
            EntryQualifier entry = new EntryQualifier(prefix, this.names[i]);
            ImportBuilder builder = new ImportBuilder(entry, null);
            try {
                this.statements[i] = builder.create(module, path, line);
                continue;
            }
            catch (Exception cause) {
                interceptor.traceCompileError(scope, trace, cause);
                return new ExceptionStatement("Could not process import", cause);
            }
        }
        return new StatementBlock(this.statements);
    }

    private static class EntryQualifier
    implements Qualifier {
        private final String target;
        private final String prefix;

        public EntryQualifier(String prefix, Qualifier target) {
            this.target = target.getQualifier();
            this.prefix = prefix;
        }

        @Override
        public String getQualifier() {
            return this.prefix;
        }

        @Override
        public String getLocation() {
            return this.prefix;
        }

        @Override
        public String getTarget() {
            return this.target;
        }

        @Override
        public String getName() {
            return this.target;
        }
    }
}

