/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree;

import java.util.HashMap;
import java.util.Map;
import org.snapscript.core.Context;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeLoader;
import org.snapscript.tree.Instruction;
import org.snapscript.tree.InstructionReader;
import org.snapscript.tree.Operation;

public class InstructionBuilder {
    private final InstructionReader reader;
    private final Context context;

    public InstructionBuilder(Context context, String file) {
        this.reader = new InstructionReader(file);
        this.context = context;
    }

    public Map<String, Operation> create() throws Exception {
        HashMap<String, Operation> table = new HashMap<String, Operation>();
        for (Instruction instruction : this.reader) {
            Operation operation = this.create(instruction);
            String grammar = instruction.getName();
            table.put(grammar, operation);
        }
        return table;
    }

    private Operation create(Instruction instruction) throws Exception {
        TypeLoader loader = this.context.getLoader();
        String value = instruction.getType();
        Type type = loader.loadType(value);
        String name = instruction.getName();
        return new Operation(type, name);
    }
}

