/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree;

import java.util.Set;
import org.snapscript.core.Context;
import org.snapscript.core.module.Module;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeExtractor;

public class ModifierAccessVerifier {
    public boolean isAccessible(Scope scope, Type owner) {
        Type caller = scope.getType();
        if (caller != null) {
            return this.isAccessible(caller, owner);
        }
        return false;
    }

    public boolean isAccessible(Type caller, Type owner) {
        if (caller != null && owner != null) {
            if (this.isSuper(caller, owner)) {
                return true;
            }
            if (this.isCompatible(caller, owner)) {
                if (this.isEnclosing(caller, owner)) {
                    return true;
                }
                if (this.isEnclosing(owner, caller)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean isSuper(Type caller, Type owner) {
        if (caller != owner) {
            Module module = caller.getModule();
            Context context = module.getContext();
            TypeExtractor extractor = context.getExtractor();
            Set<Type> types = extractor.getTypes(caller);
            return types.contains(owner);
        }
        return true;
    }

    private boolean isCompatible(Type caller, Type owner) {
        Module require;
        Module actual = caller.getModule();
        return actual == (require = owner.getModule());
    }

    private boolean isEnclosing(Type parent, Type child) {
        String outer = parent.getName();
        String inner = child.getName();
        if (inner.startsWith(outer)) {
            int length = outer.length();
            int index = inner.indexOf(36, length);
            return index == length;
        }
        return false;
    }
}

