/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree;

import org.snapscript.core.Compilation;
import org.snapscript.core.Context;
import org.snapscript.core.Evaluation;
import org.snapscript.core.Execution;
import org.snapscript.core.Statement;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.convert.ConstraintConverter;
import org.snapscript.core.convert.ConstraintMatcher;
import org.snapscript.core.convert.Score;
import org.snapscript.core.error.ErrorHandler;
import org.snapscript.core.error.Reason;
import org.snapscript.core.module.Module;
import org.snapscript.core.module.Path;
import org.snapscript.core.result.Result;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.trace.Trace;
import org.snapscript.core.trace.TraceInterceptor;
import org.snapscript.core.trace.TraceStatement;
import org.snapscript.core.type.Type;
import org.snapscript.core.variable.Value;
import org.snapscript.parse.StringToken;

public class ReturnStatement
implements Compilation {
    private final Evaluation evaluation;

    public ReturnStatement(StringToken token) {
        this(null, token);
    }

    public ReturnStatement(Evaluation evaluation) {
        this(evaluation, null);
    }

    public ReturnStatement(Evaluation evaluation, StringToken token) {
        this.evaluation = evaluation;
    }

    @Override
    public Statement compile(Module module, Path path, int line) throws Exception {
        Context context = module.getContext();
        ErrorHandler handler = context.getHandler();
        TraceInterceptor interceptor = context.getInterceptor();
        Trace trace = Trace.getNormal(module, path, line);
        Statement statement = this.create(module, path, line);
        return new TraceStatement(interceptor, handler, statement, trace);
    }

    private Statement create(Module module, Path path, int line) throws Exception {
        Context context = module.getContext();
        ErrorHandler handler = context.getHandler();
        ConstraintMatcher matcher = context.getMatcher();
        return new CompileResult(matcher, handler, this.evaluation);
    }

    private static class CompileExecution
    extends Execution {
        private final Evaluation evaluation;

        public CompileExecution(Evaluation evaluation) {
            this.evaluation = evaluation;
        }

        @Override
        public Result execute(Scope scope) throws Exception {
            if (this.evaluation != null) {
                Value value = this.evaluation.evaluate(scope, null);
                Object object = value.getValue();
                return Result.getReturn(object);
            }
            return Result.RETURN;
        }
    }

    private static class CompileResult
    extends Statement {
        private final ConstraintMatcher matcher;
        private final ErrorHandler handler;
        private final Evaluation evaluation;

        public CompileResult(ConstraintMatcher matcher, ErrorHandler handler, Evaluation evaluation) {
            this.evaluation = evaluation;
            this.matcher = matcher;
            this.handler = handler;
        }

        @Override
        public boolean define(Scope scope) throws Exception {
            if (this.evaluation != null) {
                this.evaluation.define(scope);
            }
            return true;
        }

        @Override
        public Execution compile(Scope scope, Constraint returns) throws Exception {
            if (this.evaluation != null) {
                Constraint constraint = this.evaluation.compile(scope, null);
                if (returns != null) {
                    ConstraintConverter converter;
                    Score score;
                    Type require = returns.getType(scope);
                    Type actual = constraint.getType(scope);
                    if (require != null && (score = (converter = this.matcher.match(require)).score(actual)).isInvalid()) {
                        this.handler.handleCompileError(Reason.CAST, scope, require, actual);
                    }
                }
            }
            return new CompileExecution(this.evaluation);
        }
    }
}

