/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree;

import org.snapscript.core.Execution;
import org.snapscript.core.Statement;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.result.Result;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.scope.index.Index;
import org.snapscript.core.yield.Resume;
import org.snapscript.core.yield.Yield;
import org.snapscript.tree.CompoundResume;
import org.snapscript.tree.SuspendStatement;

public class StatementBlock
extends Statement {
    private volatile StatementCompiler compiler;
    private volatile StatementBuilder builder;

    public StatementBlock(Statement ... statements) {
        this.builder = new StatementBuilder(statements);
    }

    @Override
    public void create(Scope scope) throws Exception {
        this.builder.create(scope);
    }

    @Override
    public boolean define(Scope scope) throws Exception {
        if (this.compiler == null) {
            this.compiler = this.builder.define(scope);
        }
        return true;
    }

    @Override
    public Execution compile(Scope scope, Constraint returns) throws Exception {
        if (this.compiler == null) {
            throw new InternalStateException("Statement was not created");
        }
        return this.compiler.compile(scope, returns);
    }

    private static class StatementExecutor
    extends SuspendStatement<Integer> {
        private final Execution[] executions;

        public StatementExecutor(Execution[] executions) {
            this.executions = executions;
        }

        @Override
        public Result execute(Scope scope) throws Exception {
            return this.resume(scope, 0);
        }

        @Override
        public Result resume(Scope scope, Integer index) throws Exception {
            Result last = Result.NORMAL;
            for (int i = index.intValue(); i < this.executions.length; ++i) {
                Execution execution = this.executions[i];
                Result result = execution.execute(scope);
                if (result.isYield()) {
                    return this.suspend(scope, result, this, i + 1);
                }
                if (!result.isNormal()) {
                    return result;
                }
                last = result;
            }
            return last;
        }

        @Override
        public Resume suspend(Result result, Resume resume, Integer value) throws Exception {
            Yield yield = (Yield)result.getValue();
            Resume child = yield.getResume();
            return new CompoundResume(child, resume, value);
        }
    }

    private static class StatementCompiler {
        private final Statement[] statements;
        private final Statement[] executable;
        private final Execution[] executions;

        public StatementCompiler(Statement[] statements, Statement[] executable) {
            this.executions = new Execution[statements.length];
            this.executable = executable;
            this.statements = statements;
        }

        public Execution compile(Scope scope, Constraint returns) throws Exception {
            Statement statement;
            int i;
            for (i = 0; i < this.executable.length; ++i) {
                statement = this.executable[i];
                if (statement == null) continue;
                this.executions[i] = statement.compile(scope, returns);
            }
            for (i = 0; i < this.statements.length; ++i) {
                statement = this.statements[i];
                if (statement == null) continue;
                this.executions[i] = statement.compile(scope, returns);
            }
            return new StatementExecutor(this.executions);
        }
    }

    private static class StatementBuilder {
        private final Statement[] statements;
        private final Statement[] executable;

        public StatementBuilder(Statement[] statements) {
            this.executable = new Statement[statements.length];
            this.statements = statements;
        }

        public void create(Scope scope) throws Exception {
            for (int i = 0; i < this.statements.length; ++i) {
                Statement statement = this.statements[i];
                if (statement == null) continue;
                statement.create(scope);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public StatementCompiler define(Scope scope) throws Exception {
            Index index = scope.getIndex();
            int size = index.size();
            try {
                for (int i = 0; i < this.statements.length; ++i) {
                    Statement statement = this.statements[i];
                    if (!statement.define(scope)) continue;
                    this.executable[i] = statement;
                    this.statements[i] = null;
                }
            }
            finally {
                index.reset(size);
            }
            return new StatementCompiler(this.statements, this.executable);
        }
    }
}

