/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.snapscript.core.ModifierType;
import org.snapscript.core.function.Function;
import org.snapscript.core.property.Property;
import org.snapscript.core.type.Type;

public class StaticImportMatcher {
    public List<Function> matchFunctions(Type type, String prefix) throws Exception {
        List<Function> functions = type.getFunctions();
        if (!functions.isEmpty()) {
            ArrayList<Function> matches = new ArrayList<Function>();
            for (Function function : functions) {
                int modifiers = function.getModifiers();
                if (!ModifierType.isStatic(modifiers) || !ModifierType.isPublic(modifiers)) continue;
                String name = function.getName();
                if (prefix != null && !prefix.equals(name)) continue;
                matches.add(function);
            }
            return matches;
        }
        return Collections.emptyList();
    }

    public List<Property> matchProperties(Type type, String prefix) throws Exception {
        List<Property> properties = type.getProperties();
        if (!properties.isEmpty()) {
            ArrayList<Property> matches = new ArrayList<Property>();
            for (Property property : properties) {
                int modifiers = property.getModifiers();
                if (!ModifierType.isStatic(modifiers) || !ModifierType.isPublic(modifiers)) continue;
                String name = property.getName();
                if (prefix != null && !prefix.equals(name)) continue;
                matches.add(property);
            }
            return matches;
        }
        return Collections.emptyList();
    }
}

