/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree;

import java.util.concurrent.atomic.AtomicBoolean;
import org.snapscript.core.Context;
import org.snapscript.core.Execution;
import org.snapscript.core.Statement;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.convert.ConstraintConverter;
import org.snapscript.core.convert.ConstraintMatcher;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.function.Invocation;
import org.snapscript.core.function.InvocationBuilder;
import org.snapscript.core.function.Signature;
import org.snapscript.core.function.SignatureAligner;
import org.snapscript.core.module.Module;
import org.snapscript.core.result.Result;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;
import org.snapscript.tree.function.ParameterExtractor;

public class StaticInvocationBuilder
implements InvocationBuilder {
    private ParameterExtractor extractor;
    private ResultConverter converter;
    private SignatureAligner aligner;
    private Constraint constraint;
    private Statement statement;
    private Execution execution;
    private Execution compile;

    public StaticInvocationBuilder(Signature signature, Execution compile, Statement statement, Constraint constraint) {
        this.extractor = new ParameterExtractor(signature, true);
        this.aligner = new SignatureAligner(signature);
        this.constraint = constraint;
        this.statement = statement;
        this.compile = compile;
    }

    @Override
    public void define(Scope scope) throws Exception {
        this.extractor.define(scope);
        this.statement.define(scope);
        this.constraint.getType(scope);
    }

    @Override
    public void compile(Scope scope) throws Exception {
        if (this.execution != null) {
            throw new InternalStateException("Function has already been compiled");
        }
        this.execution = this.statement.compile(scope, this.constraint);
    }

    @Override
    public Invocation create(Scope scope) throws Exception {
        if (this.converter == null) {
            this.converter = this.build(scope);
        }
        return this.converter;
    }

    private ResultConverter build(Scope scope) throws Exception {
        Module module = scope.getModule();
        Context context = module.getContext();
        ConstraintMatcher matcher = context.getMatcher();
        return new ResultConverter(matcher, this.compile, this.execution);
    }

    private class ResultConverter
    implements Invocation<Object> {
        private final ConstraintMatcher matcher;
        private final AtomicBoolean execute = new AtomicBoolean(false);
        private final Execution execution;
        private final Execution compile;

        public ResultConverter(ConstraintMatcher matcher, Execution compile, Execution execution) {
            this.execution = execution;
            this.matcher = matcher;
            this.compile = compile;
        }

        @Override
        public Object invoke(Scope scope, Object object, Object ... list) throws Exception {
            Result result;
            Object value;
            Object[] arguments = StaticInvocationBuilder.this.aligner.align(list);
            Scope inner = StaticInvocationBuilder.this.extractor.extract(scope, arguments);
            if (this.execute.compareAndSet(false, true)) {
                this.compile.execute(inner);
            }
            if ((value = (result = this.execution.execute(inner)).getValue()) != null) {
                Type type = StaticInvocationBuilder.this.constraint.getType(scope);
                ConstraintConverter converter = this.matcher.match(type);
                return converter.assign(value);
            }
            return value;
        }
    }
}

