/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree;

import org.snapscript.core.Context;
import org.snapscript.core.Evaluation;
import org.snapscript.core.ModifierType;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.function.Function;
import org.snapscript.core.module.Module;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.scope.ScopeBinder;
import org.snapscript.core.scope.State;
import org.snapscript.core.scope.instance.Instance;
import org.snapscript.core.stack.ThreadStack;
import org.snapscript.core.type.Type;
import org.snapscript.core.variable.Value;
import org.snapscript.parse.StringToken;

public class Super
extends Evaluation {
    private final ScopeBinder binder = new ScopeBinder();

    public Super(StringToken token) {
    }

    @Override
    public Constraint compile(Scope scope, Constraint left) throws Exception {
        Scope instance = this.binder.bind(scope, scope);
        Type type = instance.getType();
        return Constraint.getConstraint(type, ModifierType.CONSTANT.mask);
    }

    @Override
    public Value evaluate(Scope scope, Value left) throws Exception {
        Module module = scope.getModule();
        Context context = module.getContext();
        ThreadStack stack = context.getStack();
        Function function = stack.current();
        if (function == null) {
            throw new InternalStateException("No enclosing function for 'super' reference");
        }
        State state = scope.getState();
        Value value = state.getValue("this");
        if (value == null) {
            throw new InternalStateException("No enclosing type for 'super' reference");
        }
        Instance instance = (Instance)value.getValue();
        Instance base = this.resolve(instance, function);
        if (base == null) {
            throw new InternalStateException("Illegal reference to 'super'");
        }
        return Value.getTransient(base);
    }

    private Instance resolve(Instance instance, Function function) {
        Type source = function.getSource();
        for (Instance next = instance; next != null; next = next.getSuper()) {
            Type actual = next.getHandle();
            if (source != actual) continue;
            return next.getSuper();
        }
        return null;
    }
}

