/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree;

import org.snapscript.core.Compilation;
import org.snapscript.core.Context;
import org.snapscript.core.Execution;
import org.snapscript.core.Statement;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.ErrorHandler;
import org.snapscript.core.error.Reason;
import org.snapscript.core.module.Module;
import org.snapscript.core.module.Path;
import org.snapscript.core.result.Result;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.yield.Resume;
import org.snapscript.core.yield.Yield;
import org.snapscript.tree.CatchBlockList;
import org.snapscript.tree.StatementResume;
import org.snapscript.tree.SuspendStatement;
import org.snapscript.tree.TryResume;

public class TryStatement
implements Compilation {
    private final CatchBlockList list;
    private final Statement statement;
    private final Statement finish;

    public TryStatement(Statement statement, Statement finish) {
        this(statement, null, finish);
    }

    public TryStatement(Statement statement, CatchBlockList list) {
        this(statement, list, null);
    }

    public TryStatement(Statement statement, CatchBlockList list, Statement finish) {
        this.statement = statement;
        this.finish = finish;
        this.list = list;
    }

    @Override
    public Object compile(Module module, Path path, int line) throws Exception {
        Context context = module.getContext();
        ErrorHandler handler = context.getHandler();
        return new CompileResult(handler, this.statement, this.list, this.finish);
    }

    private static class CompileExecution
    extends SuspendStatement<Resume> {
        private final StatementResume statement;
        private final ErrorHandler handler;
        private final Execution finish;
        private final CatchBlockList list;

        public CompileExecution(ErrorHandler handler, Execution statement, CatchBlockList list, Execution finish) {
            this.statement = new StatementResume(statement);
            this.handler = handler;
            this.finish = finish;
            this.list = list;
        }

        @Override
        public Result execute(Scope scope) throws Exception {
            return this.resume(scope, this.statement);
        }

        @Override
        public Result resume(Scope scope, Resume statement) throws Exception {
            Result result = this.handle(scope, statement);
            if (result.isYield()) {
                return this.suspend(scope, result, this, null);
            }
            return this.process(scope, result);
        }

        @Override
        public Resume suspend(Result result, Resume resume, Resume value) throws Exception {
            Yield yield = (Yield)result.getValue();
            Resume child = yield.getResume();
            return new TryResume(child, resume);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Result process(Scope scope, Result result) throws Exception {
            try {
                if (this.list != null && result.isThrow()) {
                    result = this.list.execute(scope, result);
                }
                if (result.isThrow()) {
                    Object value = result.getValue();
                    this.handler.handleInternalError(Reason.THROW, scope, value);
                }
            }
            finally {
                if (this.finish != null) {
                    this.finish.execute(scope);
                }
            }
            return result;
        }

        private Result handle(Scope scope, Resume statement) throws Exception {
            try {
                return statement.resume(scope, null);
            }
            catch (Throwable cause) {
                return Result.getThrow(cause);
            }
        }
    }

    private static class CompileResult
    extends Statement {
        private final ErrorHandler handler;
        private final CatchBlockList list;
        private final Statement statement;
        private final Statement finish;

        public CompileResult(ErrorHandler handler, Statement statement, CatchBlockList list, Statement finish) {
            this.statement = statement;
            this.handler = handler;
            this.finish = finish;
            this.list = list;
        }

        @Override
        public boolean define(Scope scope) throws Exception {
            this.statement.define(scope);
            if (this.list != null) {
                this.list.define(scope);
            }
            if (this.finish != null) {
                this.finish.define(scope);
            }
            return true;
        }

        @Override
        public Execution compile(Scope scope, Constraint returns) throws Exception {
            Execution body = this.statement.compile(scope, returns);
            Execution after = null;
            if (this.list != null) {
                this.list.compile(scope);
            }
            if (this.finish != null) {
                after = this.finish.compile(scope, returns);
            }
            return new CompileExecution(this.handler, body, this.list, after);
        }
    }
}

