/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.annotation;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.snapscript.core.Evaluation;
import org.snapscript.core.annotation.Annotation;
import org.snapscript.core.annotation.MapAnnotation;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.variable.Value;
import org.snapscript.tree.annotation.AnnotationName;
import org.snapscript.tree.construct.MapEntryList;

public class AnnotationDeclaration
extends Evaluation {
    private AnnotationName name;
    private MapEntryList list;
    private Value value;

    public AnnotationDeclaration(AnnotationName name) {
        this(name, null);
    }

    public AnnotationDeclaration(AnnotationName name, MapEntryList list) {
        this.list = list;
        this.name = name;
    }

    @Override
    public Value evaluate(Scope scope, Value left) throws Exception {
        if (this.value == null) {
            Annotation annotation = this.create(scope, left);
            if (annotation == null) {
                throw new InternalStateException("Could not create annotation");
            }
            this.value = Value.getTransient(annotation);
        }
        return this.value;
    }

    private Annotation create(Scope scope, Value left) throws Exception {
        Value value;
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        if (this.list != null) {
            value = this.list.evaluate(scope, left);
            Map map = (Map)value.getValue();
            Set keys = map.keySet();
            for (Object key : keys) {
                String name = String.valueOf(key);
                Object attribute = map.get(name);
                attributes.put(name, attribute);
            }
        }
        value = this.name.evaluate(scope, left);
        String name = value.getString();
        return new MapAnnotation(name, attributes);
    }
}

