/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.collection;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.snapscript.core.Context;
import org.snapscript.core.array.ArrayBuilder;
import org.snapscript.core.convert.proxy.ProxyWrapper;
import org.snapscript.core.error.InternalArgumentException;
import org.snapscript.core.module.Module;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;
import org.snapscript.tree.collection.Iteration;
import org.snapscript.tree.collection.ProxyIterable;
import org.snapscript.tree.collection.Sequence;

public class IterationConverter {
    private final ArrayBuilder builder = new ArrayBuilder();

    public Iteration convert(Scope scope, Object value) throws Exception {
        Module module = scope.getModule();
        Context context = module.getContext();
        ProxyWrapper wrapper = context.getWrapper();
        Class<?> type = value.getClass();
        if (type.isArray()) {
            return new ArrayIteration(wrapper, value);
        }
        if (Sequence.class.isInstance(value)) {
            return new SequenceIteration(value);
        }
        if (Iterable.class.isInstance(value)) {
            return new IterableIteration(wrapper, value);
        }
        if (Map.class.isInstance(value)) {
            return new MapIteration(wrapper, value);
        }
        if (Enumeration.class.isInstance(value)) {
            return new EnumerationIteration(wrapper, value);
        }
        throw new InternalArgumentException("Iteration for " + type + " is not possible");
    }

    private class EnumerationIteration
    implements Iteration {
        private final ProxyWrapper wrapper;
        private final Object value;

        public EnumerationIteration(ProxyWrapper wrapper, Object value) {
            this.wrapper = wrapper;
            this.value = value;
        }

        @Override
        public Type getEntry(Scope scope) throws Exception {
            Module module = scope.getModule();
            return module.getType(Object.class);
        }

        @Override
        public Iterable getIterable(Scope scope) throws Exception {
            Enumeration list = (Enumeration)this.value;
            if (list != null) {
                EnumerationIterable iterable = new EnumerationIterable(list);
                ProxyIterable proxy = new ProxyIterable(this.wrapper, iterable);
                return proxy;
            }
            return Collections.emptyList();
        }

        private class EnumerationIterator
        implements Iterator {
            private final Enumeration list;

            public EnumerationIterator(Enumeration list) {
                this.list = list;
            }

            @Override
            public boolean hasNext() {
                return this.list.hasMoreElements();
            }

            public Object next() {
                return this.list.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Remove not supported");
            }
        }

        private class EnumerationIterable
        implements Iterable {
            private final Enumeration list;

            public EnumerationIterable(Enumeration list) {
                this.list = list;
            }

            public Iterator iterator() {
                return new EnumerationIterator(this.list);
            }
        }
    }

    private class IterableIteration
    implements Iteration {
        private final ProxyWrapper wrapper;
        private final Object value;

        public IterableIteration(ProxyWrapper wrapper, Object value) {
            this.wrapper = wrapper;
            this.value = value;
        }

        @Override
        public Type getEntry(Scope scope) throws Exception {
            Module module = scope.getModule();
            return module.getType(Object.class);
        }

        @Override
        public Iterable getIterable(Scope scope) throws Exception {
            Iterable iterable = (Iterable)this.value;
            if (this.value != null) {
                return new ProxyIterable(this.wrapper, iterable);
            }
            return Collections.emptyList();
        }
    }

    private class SequenceIteration
    implements Iteration {
        private final Object value;

        public SequenceIteration(Object value) {
            this.value = value;
        }

        @Override
        public Type getEntry(Scope scope) throws Exception {
            Module module = scope.getModule();
            return module.getType(Number.class);
        }

        @Override
        public Iterable getIterable(Scope scope) throws Exception {
            if (this.value != null) {
                return (Iterable)this.value;
            }
            return Collections.emptyList();
        }
    }

    private class MapIteration
    implements Iteration {
        private final ProxyWrapper wrapper;
        private final Object value;

        public MapIteration(ProxyWrapper wrapper, Object value) {
            this.wrapper = wrapper;
            this.value = value;
        }

        @Override
        public Type getEntry(Scope scope) throws Exception {
            Module module = scope.getModule();
            return module.getType(Map.Entry.class);
        }

        @Override
        public Iterable getIterable(Scope scope) throws Exception {
            Map map = (Map)this.value;
            Set set = map.entrySet();
            if (!set.isEmpty()) {
                return new ProxyIterable(this.wrapper, set);
            }
            return set;
        }
    }

    private class ArrayIteration
    implements Iteration {
        private final ProxyWrapper wrapper;
        private final Object value;

        public ArrayIteration(ProxyWrapper wrapper, Object value) {
            this.wrapper = wrapper;
            this.value = value;
        }

        @Override
        public Type getEntry(Scope scope) throws Exception {
            Module module = scope.getModule();
            Class<?> type = this.value.getClass();
            Class<?> entry = type.getComponentType();
            return module.getType(entry);
        }

        @Override
        public Iterable getIterable(Scope scope) throws Exception {
            List list = IterationConverter.this.builder.convert(this.value);
            if (!list.isEmpty()) {
                return new ProxyIterable(this.wrapper, list);
            }
            return list;
        }
    }
}

