/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.collection;

import java.util.Iterator;
import java.util.Map;
import org.snapscript.core.convert.proxy.ProxyWrapper;

public class ProxyIterable
implements Iterable {
    private final ProxyWrapper wrapper;
    private final Iterable iterable;

    public ProxyIterable(ProxyWrapper wrapper, Iterable iterable) {
        this.iterable = iterable;
        this.wrapper = wrapper;
    }

    public Iterator iterator() {
        Iterator iterator = this.iterable.iterator();
        return new ProxyIterator(iterator);
    }

    private class ProxyEntry
    implements Map.Entry {
        private final Map.Entry entry;

        public ProxyEntry(Map.Entry entry) {
            this.entry = entry;
        }

        public Object getKey() {
            Object key = this.entry.getKey();
            if (key != null) {
                return ProxyIterable.this.wrapper.fromProxy(key);
            }
            return key;
        }

        public Object getValue() {
            Object value = this.entry.getValue();
            if (value != null) {
                return ProxyIterable.this.wrapper.fromProxy(value);
            }
            return value;
        }

        public Object setValue(Object value) {
            Object proxy = ProxyIterable.this.wrapper.toProxy(value);
            Object previous = this.entry.setValue(proxy);
            if (previous != null) {
                return ProxyIterable.this.wrapper.fromProxy(previous);
            }
            return previous;
        }
    }

    private class ProxyIterator
    implements Iterator {
        private final Iterator iterator;

        public ProxyIterator(Iterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public Object next() {
            Object value = this.iterator.next();
            if (value != null && Map.Entry.class.isInstance(value)) {
                return new ProxyEntry((Map.Entry)value);
            }
            return ProxyIterable.this.wrapper.fromProxy(value);
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

