/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.collection;

import org.snapscript.core.Evaluation;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.variable.Value;
import org.snapscript.tree.collection.Sequence;

public class Range
extends Evaluation {
    private final Evaluation start;
    private final Evaluation finish;

    public Range(Evaluation start, Evaluation finish) {
        this.start = start;
        this.finish = finish;
    }

    @Override
    public void define(Scope scope) throws Exception {
        this.start.define(scope);
        this.finish.define(scope);
    }

    @Override
    public Constraint compile(Scope scope, Constraint left) throws Exception {
        return Constraint.ITERABLE;
    }

    @Override
    public Value evaluate(Scope scope, Value left) throws Exception {
        Sequence range = this.create(scope, left);
        return Value.getTransient(range);
    }

    private Sequence create(Scope scope, Value left) throws Exception {
        Value first = this.start.evaluate(scope, left);
        Value last = this.finish.evaluate(scope, left);
        long start = first.getLong();
        long finish = last.getLong();
        return new Sequence(start, finish);
    }
}

