/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.collection;

import java.util.Iterator;

public class Sequence
implements Iterable<Number> {
    private final long first;
    private final long last;

    public Sequence(long first, long last) {
        this.first = first;
        this.last = last;
    }

    @Override
    public Iterator<Number> iterator() {
        if (this.first > this.last) {
            return new ReverseIterator(this.first, this.last);
        }
        return new ForwardIterator(this.first, this.last);
    }

    private static class ReverseIterator
    implements Iterator<Number> {
        private long first;
        private long last;

        public ReverseIterator(long first, long last) {
            this.first = first;
            this.last = last;
        }

        @Override
        public boolean hasNext() {
            return this.first >= this.last;
        }

        @Override
        public Number next() {
            if (this.first >= this.last) {
                return this.first--;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Illegal modification of range");
        }
    }

    private static class ForwardIterator
    implements Iterator<Number> {
        private long first;
        private long last;

        public ForwardIterator(Long first, Long last) {
            this.first = first;
            this.last = last;
        }

        @Override
        public boolean hasNext() {
            return this.first <= this.last;
        }

        @Override
        public Number next() {
            if (this.first <= this.last) {
                return this.first++;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Illegal modification of range");
        }
    }
}

