/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.compile;

import java.util.List;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.function.Function;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.scope.State;
import org.snapscript.core.scope.index.LocalScopeExtractor;
import org.snapscript.core.type.Type;
import org.snapscript.tree.compile.ScopeCompiler;
import org.snapscript.tree.constraint.GenericList;

public class FunctionScopeCompiler
extends ScopeCompiler {
    protected final LocalScopeExtractor extractor = new LocalScopeExtractor(false, true);
    protected final GenericList generics;

    public FunctionScopeCompiler(GenericList generics) {
        this.generics = generics;
    }

    @Override
    public Scope define(Scope local, Type type) throws Exception {
        List<Constraint> constraints = this.generics.getGenerics(local);
        Scope scope = this.extractor.extract(local);
        State state = scope.getState();
        int size = constraints.size();
        for (int i = 0; i < size; ++i) {
            Constraint constraint = constraints.get(i);
            String name = constraint.getName(scope);
            state.addConstraint(name, constraint);
        }
        return scope;
    }

    @Override
    public Scope compile(Scope local, Type type, Function function) throws Exception {
        List<Constraint> constraints = this.generics.getGenerics(local);
        Scope scope = this.extractor.extract(local);
        State state = scope.getState();
        int size = constraints.size();
        this.compileParameters(scope, function);
        for (int i = 0; i < size; ++i) {
            Constraint constraint = constraints.get(i);
            String name = constraint.getName(scope);
            state.addConstraint(name, constraint);
        }
        return scope;
    }
}

