/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.condition;

import org.snapscript.core.Evaluation;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.variable.Value;
import org.snapscript.tree.condition.BooleanChecker;

public class Choice
extends Evaluation {
    private final Evaluation condition;
    private final Evaluation positive;
    private final Evaluation negative;

    public Choice(Evaluation condition, Evaluation positive, Evaluation negative) {
        this.condition = condition;
        this.positive = positive;
        this.negative = negative;
    }

    @Override
    public void define(Scope scope) throws Exception {
        this.condition.define(scope);
        this.positive.define(scope);
        this.negative.define(scope);
    }

    @Override
    public Constraint compile(Scope scope, Constraint left) throws Exception {
        this.condition.compile(scope, null);
        this.negative.compile(scope, null);
        return this.positive.compile(scope, null);
    }

    @Override
    public Value evaluate(Scope scope, Value left) throws Exception {
        Value result = this.condition.evaluate(scope, Value.NULL);
        Object value = result.getValue();
        if (BooleanChecker.isTrue(value)) {
            return this.positive.evaluate(scope, left);
        }
        return this.negative.evaluate(scope, left);
    }
}

