/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.condition;

import org.snapscript.core.Evaluation;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.variable.BooleanValue;
import org.snapscript.core.variable.Value;
import org.snapscript.parse.StringToken;
import org.snapscript.tree.condition.BooleanChecker;
import org.snapscript.tree.condition.ConditionalOperator;

public class Combination
extends Evaluation {
    private final ConditionalOperator operator;
    private final Evaluation right;
    private final Evaluation left;

    public Combination(Evaluation left) {
        this(left, null, null);
    }

    public Combination(Evaluation left, StringToken operator, Evaluation right) {
        this.operator = ConditionalOperator.resolveOperator(operator);
        this.right = right;
        this.left = left;
    }

    @Override
    public void define(Scope scope) throws Exception {
        this.left.define(scope);
        if (this.right != null) {
            this.right.define(scope);
        }
    }

    @Override
    public Constraint compile(Scope scope, Constraint context) throws Exception {
        this.left.compile(scope, null);
        if (this.right != null) {
            this.right.compile(scope, null);
        }
        return Constraint.BOOLEAN;
    }

    @Override
    public Value evaluate(Scope scope, Value context) throws Exception {
        Value first = this.evaluate(scope, this.left);
        if (first == BooleanValue.TRUE ? this.operator != null && this.operator.isAnd() : this.operator != null && this.operator.isOr()) {
            return this.evaluate(scope, this.right);
        }
        return first;
    }

    private Value evaluate(Scope scope, Evaluation evaluation) throws Exception {
        Value value = evaluation.evaluate(scope, null);
        Object result = value.getValue();
        if (BooleanChecker.isTrue(result)) {
            return BooleanValue.TRUE;
        }
        return BooleanValue.FALSE;
    }
}

