/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.condition;

import org.snapscript.core.Evaluation;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.variable.Value;
import org.snapscript.parse.StringToken;
import org.snapscript.tree.condition.RelationalOperator;

public class Comparison
extends Evaluation {
    private final RelationalOperator operator;
    private final Evaluation left;
    private final Evaluation right;

    public Comparison(Evaluation left) {
        this(left, null, null);
    }

    public Comparison(Evaluation left, StringToken operator, Evaluation right) {
        this.operator = RelationalOperator.resolveOperator(operator);
        this.left = left;
        this.right = right;
    }

    @Override
    public void define(Scope scope) throws Exception {
        if (this.right != null) {
            this.right.define(scope);
        }
        this.left.define(scope);
    }

    @Override
    public Constraint compile(Scope scope, Constraint context) throws Exception {
        if (this.right != null) {
            this.right.compile(scope, null);
        }
        this.left.compile(scope, null);
        return Constraint.BOOLEAN;
    }

    @Override
    public Value evaluate(Scope scope, Value context) throws Exception {
        if (this.right != null) {
            Value leftResult = this.left.evaluate(scope, Value.NULL);
            Value rightResult = this.right.evaluate(scope, Value.NULL);
            return this.operator.operate(scope, leftResult, rightResult);
        }
        return this.left.evaluate(scope, Value.NULL);
    }
}

