/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.condition;

import org.snapscript.core.Compilation;
import org.snapscript.core.Context;
import org.snapscript.core.Evaluation;
import org.snapscript.core.Execution;
import org.snapscript.core.Statement;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.ErrorHandler;
import org.snapscript.core.module.Module;
import org.snapscript.core.module.Path;
import org.snapscript.core.result.Result;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.scope.index.Index;
import org.snapscript.core.trace.Trace;
import org.snapscript.core.trace.TraceInterceptor;
import org.snapscript.core.trace.TraceStatement;
import org.snapscript.core.variable.Value;
import org.snapscript.core.yield.Resume;
import org.snapscript.core.yield.Yield;
import org.snapscript.tree.SuspendStatement;
import org.snapscript.tree.condition.BooleanChecker;
import org.snapscript.tree.condition.ForResume;

public class ForStatement
implements Compilation {
    private final Statement loop;

    public ForStatement(Statement declaration, Evaluation evaluation, Statement statement) {
        this(declaration, evaluation, null, statement);
    }

    public ForStatement(Statement declaration, Evaluation evaluation, Evaluation assignment, Statement statement) {
        this.loop = new CompileResult(declaration, evaluation, assignment, statement);
    }

    @Override
    public Statement compile(Module module, Path path, int line) throws Exception {
        Context context = module.getContext();
        ErrorHandler handler = context.getHandler();
        TraceInterceptor interceptor = context.getInterceptor();
        Trace trace = Trace.getNormal(module, path, line);
        return new TraceStatement(interceptor, handler, this.loop, trace);
    }

    private static class CompileExecution
    extends SuspendStatement<Object> {
        private final Evaluation condition;
        private final Execution declaration;
        private final Evaluation assignment;
        private final Execution body;

        public CompileExecution(Execution declaration, Evaluation condition, Evaluation assignment, Execution body) {
            this.declaration = declaration;
            this.assignment = assignment;
            this.condition = condition;
            this.body = body;
        }

        @Override
        public Result execute(Scope scope) throws Exception {
            this.declaration.execute(scope);
            return this.resume(scope, (Object)null);
        }

        @Override
        public Result resume(Scope scope, Object data) throws Exception {
            while (true) {
                Value value;
                Object result;
                if (BooleanChecker.isTrue(result = (value = this.condition.evaluate(scope, null)).getValue())) {
                    Result next = this.body.execute(scope);
                    if (next.isYield()) {
                        return this.suspend(scope, next, this, this.assignment);
                    }
                    if (next.isReturn()) {
                        return next;
                    }
                    if (next.isBreak()) {
                        return Result.NORMAL;
                    }
                } else {
                    return Result.NORMAL;
                }
                if (this.assignment == null) continue;
                this.assignment.evaluate(scope, null);
            }
        }

        @Override
        public Resume suspend(Result result, Resume resume, Object value) throws Exception {
            Yield yield = (Yield)result.getValue();
            Resume child = yield.getResume();
            return new ForResume(child, resume, this.assignment);
        }
    }

    private static class CompileResult
    extends Statement {
        private final Evaluation condition;
        private final Statement declaration;
        private final Evaluation assignment;
        private final Statement body;

        public CompileResult(Statement declaration, Evaluation condition, Evaluation assignment, Statement body) {
            this.declaration = declaration;
            this.assignment = assignment;
            this.condition = condition;
            this.body = body;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean define(Scope scope) throws Exception {
            Index index = scope.getIndex();
            int size = index.size();
            try {
                this.declaration.define(scope);
                this.condition.define(scope);
                if (this.assignment != null) {
                    this.assignment.define(scope);
                }
                this.body.define(scope);
            }
            finally {
                index.reset(size);
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Execution compile(Scope scope, Constraint returns) throws Exception {
            Index index = scope.getIndex();
            int size = index.size();
            try {
                Execution variable = this.declaration.compile(scope, null);
                Execution execution = this.body.compile(scope, returns);
                this.condition.compile(scope, null);
                if (this.assignment != null) {
                    this.assignment.compile(scope, null);
                }
                CompileExecution compileExecution = new CompileExecution(variable, this.condition, this.assignment, execution);
                return compileExecution;
            }
            finally {
                index.reset(size);
            }
        }
    }
}

