/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.condition;

import org.snapscript.core.Compilation;
import org.snapscript.core.Context;
import org.snapscript.core.Evaluation;
import org.snapscript.core.Execution;
import org.snapscript.core.Statement;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.ErrorHandler;
import org.snapscript.core.module.Module;
import org.snapscript.core.module.Path;
import org.snapscript.core.result.Result;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.trace.Trace;
import org.snapscript.core.trace.TraceInterceptor;
import org.snapscript.core.trace.TraceStatement;
import org.snapscript.core.variable.Value;
import org.snapscript.tree.condition.BooleanChecker;

public class IfStatement
implements Compilation {
    private final Statement branch;

    public IfStatement(Evaluation evaluation, Statement positive) {
        this(evaluation, positive, null);
    }

    public IfStatement(Evaluation evaluation, Statement positive, Statement negative) {
        this.branch = new CompileResult(evaluation, positive, negative);
    }

    @Override
    public Statement compile(Module module, Path path, int line) throws Exception {
        Context context = module.getContext();
        ErrorHandler handler = context.getHandler();
        TraceInterceptor interceptor = context.getInterceptor();
        Trace trace = Trace.getNormal(module, path, line);
        return new TraceStatement(interceptor, handler, this.branch, trace);
    }

    private static class CompileExecution
    extends Execution {
        private final Evaluation condition;
        private final Execution positive;
        private final Execution negative;

        public CompileExecution(Evaluation condition, Execution positive, Execution negative) {
            this.condition = condition;
            this.positive = positive;
            this.negative = negative;
        }

        @Override
        public Result execute(Scope scope) throws Exception {
            Value result = this.condition.evaluate(scope, null);
            Object value = result.getValue();
            if (BooleanChecker.isTrue(value)) {
                return this.positive.execute(scope);
            }
            if (this.negative != null) {
                return this.negative.execute(scope);
            }
            return Result.NORMAL;
        }
    }

    private static class CompileResult
    extends Statement {
        private final Evaluation condition;
        private final Statement positive;
        private final Statement negative;

        public CompileResult(Evaluation condition, Statement positive, Statement negative) {
            this.condition = condition;
            this.positive = positive;
            this.negative = negative;
        }

        @Override
        public boolean define(Scope scope) throws Exception {
            this.condition.define(scope);
            this.positive.define(scope);
            if (this.negative != null) {
                this.negative.define(scope);
            }
            return true;
        }

        @Override
        public Execution compile(Scope scope, Constraint returns) throws Exception {
            Constraint result = this.condition.compile(scope, null);
            Execution success = this.positive.compile(scope, returns);
            Execution failure = null;
            if (this.negative != null) {
                failure = this.negative.compile(scope, returns);
            }
            return new CompileExecution(this.condition, success, failure);
        }
    }
}

