/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.condition;

import org.snapscript.core.Compilation;
import org.snapscript.core.Context;
import org.snapscript.core.Execution;
import org.snapscript.core.Statement;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.ErrorHandler;
import org.snapscript.core.module.Module;
import org.snapscript.core.module.Path;
import org.snapscript.core.result.Result;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.trace.Trace;
import org.snapscript.core.trace.TraceInterceptor;
import org.snapscript.core.trace.TraceStatement;
import org.snapscript.core.yield.Resume;
import org.snapscript.core.yield.Yield;
import org.snapscript.tree.SuspendStatement;
import org.snapscript.tree.condition.LoopResume;

public class LoopStatement
implements Compilation {
    private final Statement loop;

    public LoopStatement(Statement statement) {
        this.loop = new CompileResult(statement);
    }

    @Override
    public Statement compile(Module module, Path path, int line) throws Exception {
        Context context = module.getContext();
        ErrorHandler handler = context.getHandler();
        TraceInterceptor interceptor = context.getInterceptor();
        Trace trace = Trace.getNormal(module, path, line);
        return new TraceStatement(interceptor, handler, this.loop, trace);
    }

    private static class CompileExecution
    extends SuspendStatement<Object> {
        private final Execution body;

        public CompileExecution(Execution body) {
            this.body = body;
        }

        @Override
        public Result execute(Scope scope) throws Exception {
            return this.resume(scope, (Object)null);
        }

        @Override
        public Result resume(Scope scope, Object data) throws Exception {
            Result result;
            do {
                if ((result = this.body.execute(scope)).isYield()) {
                    return this.suspend(scope, result, this, null);
                }
                if (!result.isReturn()) continue;
                return result;
            } while (!result.isBreak());
            return Result.NORMAL;
        }

        @Override
        public Resume suspend(Result result, Resume resume, Object value) throws Exception {
            Yield yield = (Yield)result.getValue();
            Resume child = yield.getResume();
            return new LoopResume(child, resume);
        }
    }

    private static class CompileResult
    extends Statement {
        private final Statement body;

        public CompileResult(Statement body) {
            this.body = body;
        }

        @Override
        public boolean define(Scope scope) throws Exception {
            this.body.define(scope);
            return true;
        }

        @Override
        public Execution compile(Scope scope, Constraint returns) throws Exception {
            Execution execution = this.body.compile(scope, returns);
            return new CompileExecution(execution);
        }
    }
}

