/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.condition;

import org.snapscript.core.Compilation;
import org.snapscript.core.Context;
import org.snapscript.core.Evaluation;
import org.snapscript.core.Execution;
import org.snapscript.core.Statement;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.ErrorHandler;
import org.snapscript.core.module.Module;
import org.snapscript.core.module.Path;
import org.snapscript.core.result.Result;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.trace.Trace;
import org.snapscript.core.trace.TraceInterceptor;
import org.snapscript.core.trace.TraceStatement;
import org.snapscript.core.variable.Value;
import org.snapscript.tree.condition.BooleanChecker;
import org.snapscript.tree.condition.Case;
import org.snapscript.tree.condition.RelationalOperator;

public class MatchStatement
implements Compilation {
    private final Statement statement;

    public MatchStatement(Evaluation evaluation, Case ... cases) {
        this.statement = new CompileResult(evaluation, cases);
    }

    @Override
    public Statement compile(Module module, Path path, int line) throws Exception {
        Context context = module.getContext();
        ErrorHandler handler = context.getHandler();
        TraceInterceptor interceptor = context.getInterceptor();
        Trace trace = Trace.getNormal(module, path, line);
        return new TraceStatement(interceptor, handler, this.statement, trace);
    }

    private static class CompileExecution
    extends Execution {
        private final Evaluation condition;
        private final CompileCase[] cases;

        public CompileExecution(Evaluation condition, CompileCase ... cases) {
            this.condition = condition;
            this.cases = cases;
        }

        @Override
        public Result execute(Scope scope) throws Exception {
            Value left = this.condition.evaluate(scope, null);
            for (int i = 0; i < this.cases.length; ++i) {
                Evaluation evaluation = this.cases[i].getEvaluation();
                if (evaluation == null) {
                    Execution statement = this.cases[i].getExecution();
                    return statement.execute(scope);
                }
                Value right = evaluation.evaluate(scope, null);
                Value value = RelationalOperator.EQUALS.operate(scope, left, right);
                Object result = value.getValue();
                if (!BooleanChecker.isTrue(result)) continue;
                Execution statement = this.cases[i].getExecution();
                if (statement != null) {
                    return statement.execute(scope);
                }
                return Result.NORMAL;
            }
            return Result.NORMAL;
        }
    }

    private static class CompileResult
    extends Statement {
        private final Evaluation condition;
        private final Case[] cases;

        public CompileResult(Evaluation condition, Case ... cases) {
            this.condition = condition;
            this.cases = cases;
        }

        @Override
        public boolean define(Scope scope) throws Exception {
            for (int i = 0; i < this.cases.length; ++i) {
                Statement statement = this.cases[i].getStatement();
                statement.define(scope);
            }
            this.condition.define(scope);
            return true;
        }

        @Override
        public Execution compile(Scope scope, Constraint returns) throws Exception {
            CompileCase[] list = new CompileCase[this.cases.length];
            for (int i = 0; i < this.cases.length; ++i) {
                Evaluation evaluation = this.cases[i].getEvaluation();
                Statement statement = this.cases[i].getStatement();
                if (evaluation != null) {
                    evaluation.compile(scope, null);
                }
                Execution execution = statement.compile(scope, returns);
                list[i] = new CompileCase(evaluation, execution);
            }
            this.condition.compile(scope, null);
            return new CompileExecution(this.condition, list);
        }
    }

    private static class CompileCase {
        private final Evaluation expression;
        private final Execution execution;

        public CompileCase(Evaluation expression, Execution execution) {
            this.expression = expression;
            this.execution = execution;
        }

        public Evaluation getEvaluation() {
            return this.expression;
        }

        public Execution getExecution() {
            return this.execution;
        }
    }
}

