/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.condition;

import org.snapscript.core.convert.InstanceOfChecker;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.variable.BooleanValue;
import org.snapscript.core.variable.Value;
import org.snapscript.parse.StringToken;
import org.snapscript.tree.condition.ValueComparator;

public enum RelationalOperator {
    SAME("==="){

        @Override
        public Value operate(Scope scope, Value left, Value right) {
            Object second;
            Object first = left.getValue();
            if (first == (second = right.getValue())) {
                return BooleanValue.TRUE;
            }
            return BooleanValue.FALSE;
        }
    }
    ,
    NOT_SAME("!=="){

        @Override
        public Value operate(Scope scope, Value left, Value right) {
            Object second;
            Object first = left.getValue();
            if (first != (second = right.getValue())) {
                return BooleanValue.TRUE;
            }
            return BooleanValue.FALSE;
        }
    }
    ,
    EQUALS("=="){

        @Override
        public Value operate(Scope scope, Value left, Value right) {
            ValueComparator comparator = ValueComparator.resolveComparator(left, right);
            if (comparator.compare(left, right) == 0) {
                return BooleanValue.TRUE;
            }
            return BooleanValue.FALSE;
        }
    }
    ,
    NOT_EQUALS("!="){

        @Override
        public Value operate(Scope scope, Value left, Value right) {
            ValueComparator comparator = ValueComparator.resolveComparator(left, right);
            if (comparator.compare(left, right) != 0) {
                return BooleanValue.TRUE;
            }
            return BooleanValue.FALSE;
        }
    }
    ,
    GREATER(">"){

        @Override
        public Value operate(Scope scope, Value left, Value right) {
            ValueComparator comparator = ValueComparator.resolveComparator(left, right);
            if (comparator.compare(left, right) > 0) {
                return BooleanValue.TRUE;
            }
            return BooleanValue.FALSE;
        }
    }
    ,
    GREATER_OR_EQUALS(">="){

        @Override
        public Value operate(Scope scope, Value left, Value right) {
            ValueComparator comparator = ValueComparator.resolveComparator(left, right);
            if (comparator.compare(left, right) >= 0) {
                return BooleanValue.TRUE;
            }
            return BooleanValue.FALSE;
        }
    }
    ,
    LESS("<"){

        @Override
        public Value operate(Scope scope, Value left, Value right) {
            ValueComparator comparator = ValueComparator.resolveComparator(left, right);
            if (comparator.compare(left, right) < 0) {
                return BooleanValue.TRUE;
            }
            return BooleanValue.FALSE;
        }
    }
    ,
    LESS_OR_EQUALS("<="){

        @Override
        public Value operate(Scope scope, Value left, Value right) {
            ValueComparator comparator = ValueComparator.resolveComparator(left, right);
            if (comparator.compare(left, right) <= 0) {
                return BooleanValue.TRUE;
            }
            return BooleanValue.FALSE;
        }
    }
    ,
    INSTANCE_OF("instanceof"){

        @Override
        public Value operate(Scope scope, Value left, Value right) {
            Object second;
            Object first = left.getValue();
            if (this.checker.isInstanceOf(scope, first, second = right.getValue())) {
                return BooleanValue.TRUE;
            }
            return BooleanValue.FALSE;
        }
    }
    ,
    NOT_INSTANCE_OF("!instanceof"){

        @Override
        public Value operate(Scope scope, Value left, Value right) {
            Object second;
            Object first = left.getValue();
            if (!this.checker.isInstanceOf(scope, first, second = right.getValue())) {
                return BooleanValue.TRUE;
            }
            return BooleanValue.FALSE;
        }
    };

    public final InstanceOfChecker checker = new InstanceOfChecker();
    public final String operator;
    private static final RelationalOperator[] VALUES;

    private RelationalOperator(String operator) {
        this.operator = operator;
    }

    public abstract Value operate(Scope var1, Value var2, Value var3);

    public static RelationalOperator resolveOperator(StringToken token) {
        if (token != null) {
            String value = token.getValue();
            for (RelationalOperator operator : VALUES) {
                if (!operator.operator.equals(value)) continue;
                return operator;
            }
        }
        return null;
    }

    static {
        VALUES = new RelationalOperator[]{EQUALS, NOT_EQUALS, LESS, GREATER, LESS_OR_EQUALS, GREATER_OR_EQUALS, INSTANCE_OF, NOT_INSTANCE_OF, SAME, NOT_SAME};
    }
}

