/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.condition;

import org.snapscript.core.Compilation;
import org.snapscript.core.Context;
import org.snapscript.core.Evaluation;
import org.snapscript.core.Execution;
import org.snapscript.core.Statement;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.ErrorHandler;
import org.snapscript.core.module.Module;
import org.snapscript.core.module.Path;
import org.snapscript.core.result.Result;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.trace.Trace;
import org.snapscript.core.trace.TraceInterceptor;
import org.snapscript.core.trace.TraceStatement;
import org.snapscript.core.variable.Value;
import org.snapscript.core.yield.Resume;
import org.snapscript.core.yield.Yield;
import org.snapscript.tree.SuspendStatement;
import org.snapscript.tree.condition.BooleanChecker;
import org.snapscript.tree.condition.WhileResume;

public class WhileStatement
implements Compilation {
    private final Statement loop;

    public WhileStatement(Evaluation evaluation, Statement body) {
        this.loop = new CompileResult(evaluation, body);
    }

    @Override
    public Statement compile(Module module, Path path, int line) throws Exception {
        Context context = module.getContext();
        ErrorHandler handler = context.getHandler();
        TraceInterceptor interceptor = context.getInterceptor();
        Trace trace = Trace.getNormal(module, path, line);
        return new TraceStatement(interceptor, handler, this.loop, trace);
    }

    private static class CompileExecution
    extends SuspendStatement<Object> {
        private final Evaluation condition;
        private final Execution body;

        public CompileExecution(Evaluation condition, Execution body) {
            this.condition = condition;
            this.body = body;
        }

        @Override
        public Result execute(Scope scope) throws Exception {
            return this.resume(scope, (Object)null);
        }

        @Override
        public Result resume(Scope scope, Object data) throws Exception {
            Value value;
            Object result;
            while (BooleanChecker.isTrue(result = (value = this.condition.evaluate(scope, null)).getValue())) {
                Result next = this.body.execute(scope);
                if (next.isYield()) {
                    return this.suspend(scope, next, this, null);
                }
                if (next.isReturn()) {
                    return next;
                }
                if (!next.isBreak()) continue;
                return Result.NORMAL;
            }
            return Result.NORMAL;
        }

        @Override
        public Resume suspend(Result result, Resume resume, Object value) throws Exception {
            Yield yield = (Yield)result.getValue();
            Resume child = yield.getResume();
            return new WhileResume(child, resume);
        }
    }

    private static class CompileResult
    extends Statement {
        private final Evaluation condition;
        private final Statement body;

        public CompileResult(Evaluation condition, Statement body) {
            this.condition = condition;
            this.body = body;
        }

        @Override
        public boolean define(Scope scope) throws Exception {
            this.condition.define(scope);
            this.body.define(scope);
            return true;
        }

        @Override
        public Execution compile(Scope scope, Constraint returns) throws Exception {
            Constraint constraint = this.condition.compile(scope, null);
            Execution execution = this.body.compile(scope, returns);
            return new CompileExecution(this.condition, execution);
        }
    }
}

