/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.construct;

import java.util.LinkedHashMap;
import org.snapscript.core.Compilation;
import org.snapscript.core.Context;
import org.snapscript.core.Evaluation;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.module.Module;
import org.snapscript.core.module.Path;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.trace.Trace;
import org.snapscript.core.trace.TraceEvaluation;
import org.snapscript.core.trace.TraceInterceptor;
import org.snapscript.core.variable.Value;
import org.snapscript.parse.StringToken;
import org.snapscript.tree.construct.MapEntryList;

public class ConstructMap
implements Compilation {
    private final Evaluation construct;

    public ConstructMap(StringToken token) {
        this(null, token);
    }

    public ConstructMap(MapEntryList list) {
        this(list, null);
    }

    public ConstructMap(MapEntryList list, StringToken token) {
        this.construct = new CompileResult(list);
    }

    @Override
    public Evaluation compile(Module module, Path path, int line) throws Exception {
        Context context = module.getContext();
        TraceInterceptor interceptor = context.getInterceptor();
        Trace trace = Trace.getConstruct(module, path, line);
        return new TraceEvaluation(interceptor, this.construct, trace);
    }

    private static class CompileResult
    extends Evaluation {
        private final MapEntryList list;

        public CompileResult(MapEntryList list) {
            this.list = list;
        }

        @Override
        public void define(Scope scope) throws Exception {
            if (this.list != null) {
                this.list.define(scope);
            }
        }

        @Override
        public Constraint compile(Scope scope, Constraint left) throws Exception {
            if (this.list != null) {
                this.list.compile(scope, null);
            }
            return Constraint.MAP;
        }

        @Override
        public Value evaluate(Scope scope, Value left) throws Exception {
            LinkedHashMap map = new LinkedHashMap();
            if (this.list != null) {
                return this.list.evaluate(scope, left);
            }
            return Value.getTransient(map);
        }
    }
}

