/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.construct;

import java.util.List;
import org.snapscript.core.Evaluation;
import org.snapscript.core.constraint.CompileConstraint;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.convert.AliasResolver;
import org.snapscript.core.error.ErrorHandler;
import org.snapscript.core.error.Reason;
import org.snapscript.core.function.resolve.FunctionCall;
import org.snapscript.core.function.resolve.FunctionResolver;
import org.snapscript.core.link.ImplicitImportLoader;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;
import org.snapscript.core.variable.Value;
import org.snapscript.tree.ArgumentList;
import org.snapscript.tree.construct.ConstructArgumentList;

public class CreateObject
extends Evaluation {
    private final ConstructArgumentList arguments;
    private final ImplicitImportLoader loader;
    private final FunctionResolver resolver;
    private final ErrorHandler handler;
    private final AliasResolver alias;
    private final Constraint constraint;
    private final int violation;

    public CreateObject(FunctionResolver resolver, ErrorHandler handler, Constraint constraint, ArgumentList arguments, int violation) {
        this.arguments = new ConstructArgumentList(constraint, arguments);
        this.constraint = new CompileConstraint(constraint);
        this.loader = new ImplicitImportLoader();
        this.alias = new AliasResolver();
        this.violation = violation;
        this.resolver = resolver;
        this.handler = handler;
    }

    @Override
    public void define(Scope scope) throws Exception {
        List<String> names = this.constraint.getImports(scope);
        int count = names.size();
        if (count > 0) {
            this.loader.loadImports(scope, names);
        }
        this.arguments.define(scope);
    }

    @Override
    public Constraint compile(Scope scope, Constraint left) throws Exception {
        Type type = this.constraint.getType(scope);
        Type actual = this.alias.resolve(type);
        int modifiers = actual.getModifiers();
        if ((this.violation & modifiers) != 0) {
            this.handler.handleCompileError(Reason.CONSTRUCTION, scope, actual);
        }
        return this.arguments.compile(scope, actual);
    }

    @Override
    public Value evaluate(Scope scope, Value left) throws Exception {
        Object result;
        Object[] list;
        Type type = this.constraint.getType(scope);
        Type actual = this.alias.resolve(type);
        FunctionCall call = this.resolver.resolveStatic(scope, actual, "new", list = this.arguments.create(scope, actual));
        if (call == null) {
            this.handler.handleRuntimeError(Reason.CONSTRUCTION, scope, actual, "new", list);
        }
        if ((result = call.invoke(scope, (Object)null, list)) != null) {
            return Value.getTransient(result);
        }
        return Value.NULL;
    }
}

