/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.construct;

import java.util.LinkedHashMap;
import java.util.Map;
import org.snapscript.core.Context;
import org.snapscript.core.Evaluation;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.convert.proxy.ProxyWrapper;
import org.snapscript.core.module.Module;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.variable.Value;
import org.snapscript.tree.construct.MapEntry;

public class MapEntryList
extends Evaluation {
    private final MapEntry[] list;

    public MapEntryList(MapEntry ... list) {
        this.list = list;
    }

    @Override
    public void define(Scope scope) throws Exception {
        for (int i = 0; i < this.list.length; ++i) {
            this.list[i].define(scope);
        }
    }

    @Override
    public Constraint compile(Scope scope, Constraint left) throws Exception {
        for (int i = 0; i < this.list.length; ++i) {
            this.list[i].compile(scope);
        }
        return Constraint.NONE;
    }

    @Override
    public Value evaluate(Scope scope, Value left) throws Exception {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        for (int i = 0; i < this.list.length; ++i) {
            Map.Entry entry = this.list[i].create(scope);
            Module module = scope.getModule();
            Context context = module.getContext();
            ProxyWrapper wrapper = context.getWrapper();
            Object key = entry.getKey();
            Object value = entry.getValue();
            Object keyProxy = wrapper.toProxy(key);
            Object valueProxy = wrapper.toProxy(value);
            map.put(keyProxy, valueProxy);
        }
        return Value.getTransient(map);
    }
}

