/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.construct;

import java.util.concurrent.atomic.AtomicInteger;
import org.snapscript.core.Evaluation;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.scope.State;
import org.snapscript.core.scope.index.Index;
import org.snapscript.core.scope.index.Local;
import org.snapscript.core.scope.index.Table;
import org.snapscript.core.variable.Value;
import org.snapscript.tree.NameReference;

public class MapKey
extends Evaluation {
    private final NameReference reference;
    private final AtomicInteger offset;

    public MapKey(Evaluation key) {
        this.reference = new NameReference(key);
        this.offset = new AtomicInteger(-1);
    }

    @Override
    public void define(Scope scope) throws Exception {
        String name = this.reference.getName(scope);
        Index index = scope.getIndex();
        int depth = index.get(name);
        this.offset.set(depth);
    }

    @Override
    public Value evaluate(Scope scope, Value left) throws Exception {
        String name = this.reference.getName(scope);
        int depth = this.offset.get();
        if (depth == -1) {
            State state = scope.getState();
            Value value = state.getValue(name);
            if (value != null) {
                return value;
            }
        } else {
            Table table = scope.getTable();
            Local value = table.getLocal(depth);
            if (value != null) {
                return value;
            }
        }
        return Value.getTransient(name);
    }
}

