/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.define;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.module.Module;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.scope.State;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeBody;
import org.snapscript.core.variable.Value;
import org.snapscript.tree.annotation.AnnotationList;
import org.snapscript.tree.constraint.ClassName;
import org.snapscript.tree.define.ClassPropertyGenerator;
import org.snapscript.tree.define.ConstantPropertyBuilder;
import org.snapscript.tree.define.TypeHierarchy;

public class ClassBuilder {
    private final AtomicReference<Type> reference = new AtomicReference();
    private final ClassPropertyGenerator generator = new ClassPropertyGenerator();
    private final ConstantPropertyBuilder builder = new ConstantPropertyBuilder();
    private final AnnotationList annotations;
    private final TypeHierarchy hierarchy;
    private final ClassName name;

    public ClassBuilder(AnnotationList annotations, ClassName name, TypeHierarchy hierarchy) {
        this.annotations = annotations;
        this.hierarchy = hierarchy;
        this.name = name;
    }

    public Type create(TypeBody body, Scope outer) throws Exception {
        Module module = outer.getModule();
        String alias = this.name.getName(outer);
        int modifiers = this.name.getModifiers(outer);
        Type enclosing = outer.getType();
        Type type = module.addType(alias, modifiers);
        if (enclosing != null) {
            String name = type.getName();
            String prefix = enclosing.getName();
            String key = name.replace(prefix + '$', "");
            Value value = Value.getConstant(type);
            State state = outer.getState();
            this.builder.createStaticProperty(body, key, enclosing, Constraint.NONE);
            state.addValue(key, value);
        }
        this.reference.set(type);
        return type;
    }

    public Type define(TypeBody body, Scope outer) throws Exception {
        Type type = this.reference.get();
        Scope scope = type.getScope();
        List<Constraint> generics = this.name.getGenerics(scope);
        List<Constraint> constraints = type.getGenerics();
        constraints.addAll(generics);
        this.annotations.apply(scope, type);
        this.generator.generate(body, scope, type);
        this.hierarchy.define(scope, type);
        return type;
    }

    public Type compile(TypeBody body, Scope outer) throws Exception {
        Type type = this.reference.get();
        this.hierarchy.compile(outer, type);
        return type;
    }
}

