/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.define;

import java.util.concurrent.atomic.AtomicBoolean;
import org.snapscript.common.Progress;
import org.snapscript.core.Compilation;
import org.snapscript.core.Context;
import org.snapscript.core.Execution;
import org.snapscript.core.NoExecution;
import org.snapscript.core.Statement;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.ErrorHandler;
import org.snapscript.core.module.Module;
import org.snapscript.core.module.Path;
import org.snapscript.core.result.Result;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.trace.Trace;
import org.snapscript.core.trace.TraceInterceptor;
import org.snapscript.core.trace.TraceStatement;
import org.snapscript.core.type.Phase;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypePart;
import org.snapscript.core.type.TypeState;
import org.snapscript.tree.annotation.AnnotationList;
import org.snapscript.tree.constraint.ClassName;
import org.snapscript.tree.define.ClassBuilder;
import org.snapscript.tree.define.DefaultConstructor;
import org.snapscript.tree.define.FunctionPropertyGenerator;
import org.snapscript.tree.define.StaticState;
import org.snapscript.tree.define.TypeHierarchy;
import org.snapscript.tree.define.TypeStateCollector;

public class ClassDefinition
implements Compilation {
    private final Statement definition;

    public ClassDefinition(AnnotationList annotations, ClassName name, TypeHierarchy hierarchy, TypePart ... parts) {
        this.definition = new CompileResult(annotations, name, hierarchy, parts);
    }

    @Override
    public Statement compile(Module module, Path path, int line) throws Exception {
        Context context = module.getContext();
        ErrorHandler handler = context.getHandler();
        TraceInterceptor interceptor = context.getInterceptor();
        Trace trace = Trace.getDefine(module, path, line);
        return new TraceStatement(interceptor, handler, this.definition, trace);
    }

    private static class CompileResult
    extends Statement {
        private final FunctionPropertyGenerator generator;
        private final DefaultConstructor constructor;
        private final TypeStateCollector collector;
        private final TypeState constants;
        private final AtomicBoolean compile;
        private final AtomicBoolean define;
        private final AtomicBoolean create;
        private final ClassBuilder builder;
        private final Execution execution;
        private final TypePart[] parts;

        public CompileResult(AnnotationList annotations, ClassName name, TypeHierarchy hierarchy, TypePart[] parts) {
            this.builder = new ClassBuilder(annotations, name, hierarchy);
            this.generator = new FunctionPropertyGenerator();
            this.collector = new TypeStateCollector();
            this.constructor = new DefaultConstructor(this.collector);
            this.execution = new NoExecution(Result.NORMAL);
            this.compile = new AtomicBoolean(true);
            this.define = new AtomicBoolean(true);
            this.create = new AtomicBoolean(true);
            this.constants = new StaticState();
            this.parts = parts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void create(Scope outer) throws Exception {
            if (!this.create.compareAndSet(false, true)) {
                Type type = this.builder.create(this.collector, outer);
                Progress<Phase> progress = type.getProgress();
                Scope scope = type.getScope();
                try {
                    for (TypePart part : this.parts) {
                        part.create(this.collector, type, scope);
                    }
                }
                finally {
                    progress.done(Phase.CREATE);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean define(Scope outer) throws Exception {
            if (!this.define.compareAndSet(false, true)) {
                Type type = this.builder.define(this.collector, outer);
                Progress<Phase> progress = type.getProgress();
                Scope scope = type.getScope();
                try {
                    this.collector.update(this.constants);
                    for (TypePart part : this.parts) {
                        TypeState state = part.define(this.collector, type, scope);
                        this.collector.update(state);
                    }
                    this.collector.update(this.constructor);
                    this.collector.define(scope, type);
                    this.generator.generate(type);
                }
                finally {
                    progress.done(Phase.DEFINE);
                }
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Execution compile(Scope outer, Constraint returns) throws Exception {
            if (!this.compile.compareAndSet(false, true)) {
                Type type = this.builder.compile(this.collector, outer);
                Progress<Phase> progress = type.getProgress();
                Scope scope = type.getScope();
                Scope local = scope.getStack();
                try {
                    this.collector.compile(local, type);
                }
                finally {
                    progress.done(Phase.COMPILE);
                }
            }
            return this.execution;
        }
    }
}

