/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.define;

import java.util.List;
import org.snapscript.core.ModifierType;
import org.snapscript.core.constraint.AnyConstraint;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.constraint.ConstraintVerifier;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;
import org.snapscript.tree.constraint.ClassConstraint;
import org.snapscript.tree.constraint.TraitConstraint;
import org.snapscript.tree.define.TypeHierarchy;

public class ClassHierarchy
implements TypeHierarchy {
    private final ConstraintVerifier verifier = new ConstraintVerifier();
    private final TraitConstraint[] traits;
    private final ClassConstraint base;
    private final Constraint any = new AnyConstraint();

    public ClassHierarchy(TraitConstraint ... traits) {
        this((ClassConstraint)null, traits);
    }

    public ClassHierarchy(ClassConstraint base, TraitConstraint ... traits) {
        this.traits = traits;
        this.base = base;
    }

    @Override
    public void define(Scope scope, Type type) throws Exception {
        List<Constraint> types = type.getTypes();
        if (this.base == null) {
            types.add(this.any);
        } else {
            Type match = this.base.getType(scope);
            if (match == null) {
                throw new InternalStateException("Invalid super class for type '" + type + "'");
            }
            int modifiers = match.getModifiers();
            if (!ModifierType.isClass(modifiers)) {
                throw new InternalStateException("Invalid super class '" + match + "' for type '" + type + "'");
            }
            types.add(this.base);
        }
        for (int i = 0; i < this.traits.length; ++i) {
            TraitConstraint trait = this.traits[i];
            Type match = ((Constraint)trait).getType(scope);
            if (match == null) {
                throw new InternalStateException("Invalid trait for type '" + type + "'");
            }
            int modifiers = match.getModifiers();
            if (!ModifierType.isTrait(modifiers)) {
                throw new InternalStateException("Invalid trait '" + match + "' for type '" + type + "'");
            }
            types.add(trait);
        }
    }

    @Override
    public void compile(Scope scope, Type type) throws Exception {
        List<Constraint> types = type.getTypes();
        for (Constraint base : types) {
            try {
                this.verifier.verify(scope, base);
            }
            catch (Exception e) {
                throw new InternalStateException("Invalid super class for type '" + type + "'", e);
            }
        }
    }
}

