/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.define;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.snapscript.core.NoStatement;
import org.snapscript.core.Statement;
import org.snapscript.core.function.Function;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Category;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeBody;
import org.snapscript.core.type.TypeState;
import org.snapscript.tree.Modifier;
import org.snapscript.tree.ModifierList;
import org.snapscript.tree.annotation.AnnotationDeclaration;
import org.snapscript.tree.annotation.AnnotationList;
import org.snapscript.tree.define.ClassConstructor;
import org.snapscript.tree.define.MemberConstructor;
import org.snapscript.tree.function.ParameterDeclaration;
import org.snapscript.tree.function.ParameterList;

public class DefaultConstructor
extends TypeState {
    private final AtomicReference<TypeState> reference = new AtomicReference();
    private final MemberConstructor constructor;
    private final AnnotationList annotations = new AnnotationList(new AnnotationDeclaration[0]);
    private final ParameterList parameters = new ParameterList(new ParameterDeclaration[0]);
    private final ModifierList modifiers = new ModifierList(new Modifier[0]);
    private final Statement statement = new NoStatement();
    private final TypeBody body;
    private final boolean compile;

    public DefaultConstructor(TypeBody body) {
        this(body, true);
    }

    public DefaultConstructor(TypeBody body, boolean compile) {
        this.constructor = new ClassConstructor(this.annotations, this.modifiers, this.parameters, this.statement);
        this.compile = compile;
        this.body = body;
    }

    @Override
    public Category define(Scope scope, Type type) throws Exception {
        List<Function> functions = type.getFunctions();
        for (Function function : functions) {
            String name = function.getName();
            if (!name.equals("new")) continue;
            return Category.OTHER;
        }
        TypeState allocation = this.constructor.assemble(this.body, type, scope, this.compile);
        if (allocation != null) {
            this.reference.set(allocation);
        }
        return Category.OTHER;
    }

    @Override
    public void compile(Scope scope, Type type) throws Exception {
        TypeState state = this.reference.get();
        if (state != null) {
            state.compile(scope, type);
        }
    }
}

