/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.define;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.snapscript.core.ModifierType;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.module.Module;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.scope.State;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeBody;
import org.snapscript.core.variable.Value;
import org.snapscript.tree.constraint.EnumName;
import org.snapscript.tree.define.ConstantPropertyBuilder;
import org.snapscript.tree.define.EnumPropertyGenerator;
import org.snapscript.tree.define.TypeHierarchy;

public class EnumBuilder {
    private final AtomicReference<Type> reference = new AtomicReference();
    private final EnumPropertyGenerator generator = new EnumPropertyGenerator();
    private final ConstantPropertyBuilder builder = new ConstantPropertyBuilder();
    private final TypeHierarchy hierarchy;
    private final EnumName name;
    private final List values = new ArrayList();

    public EnumBuilder(EnumName name, TypeHierarchy hierarchy) {
        this.hierarchy = hierarchy;
        this.name = name;
    }

    public Type create(TypeBody body, Scope outer) throws Exception {
        Module module = outer.getModule();
        String alias = this.name.getName(outer);
        Type enclosing = outer.getType();
        Type type = module.addType(alias, ModifierType.ENUM.mask);
        if (enclosing != null) {
            String name = type.getName();
            String prefix = enclosing.getName();
            String key = name.replace(prefix + '$', "");
            Value value = Value.getConstant(type);
            State state = outer.getState();
            this.builder.createStaticProperty(body, key, enclosing, Constraint.NONE);
            state.addValue(key, value);
        }
        this.reference.set(type);
        return type;
    }

    public Type define(TypeBody body, Scope outer) throws Exception {
        Type type = this.reference.get();
        Scope scope = type.getScope();
        this.generator.generate(body, scope, type, this.values);
        this.hierarchy.define(scope, type);
        return type;
    }

    public Type compile(TypeBody body, Scope outer) throws Exception {
        Type type = this.reference.get();
        this.hierarchy.compile(outer, type);
        return type;
    }
}

