/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.define;

import java.util.List;
import org.snapscript.core.ModifierType;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.function.AccessorProperty;
import org.snapscript.core.function.StaticAccessor;
import org.snapscript.core.property.Property;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeBody;
import org.snapscript.core.type.TypeState;
import org.snapscript.tree.ArgumentList;
import org.snapscript.tree.NameReference;
import org.snapscript.tree.define.EnumInstance;
import org.snapscript.tree.define.EnumKey;

public class EnumValue {
    private final NameReference reference;
    private final ArgumentList arguments;

    public EnumValue(EnumKey key) {
        this(key, null);
    }

    public EnumValue(EnumKey key, ArgumentList arguments) {
        this.reference = new NameReference(key);
        this.arguments = arguments;
    }

    public TypeState define(TypeBody body, Type type, int index) throws Exception {
        Scope scope = type.getScope();
        String name = this.reference.getName(scope);
        Constraint constraint = Constraint.getConstraint(type, ModifierType.CONSTANT.mask);
        List<Property> properties = type.getProperties();
        int modifiers = type.getModifiers();
        if (!ModifierType.isEnum(modifiers)) {
            throw new InternalStateException("Type '" + type + "' is not an enum");
        }
        StaticAccessor accessor = new StaticAccessor(body, type, name);
        AccessorProperty property = new AccessorProperty(name, type, constraint, accessor, ModifierType.STATIC.mask | ModifierType.CONSTANT.mask);
        properties.add(property);
        return new EnumInstance(name, this.arguments, index);
    }
}

