/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.define;

import org.snapscript.core.ModifierType;
import org.snapscript.core.Statement;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.function.FunctionBody;
import org.snapscript.core.function.InvocationFunction;
import org.snapscript.core.function.Signature;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.type.Type;
import org.snapscript.core.type.TypeBody;
import org.snapscript.tree.StatementInvocationBuilder;
import org.snapscript.tree.define.InstanceInvocation;
import org.snapscript.tree.define.MemberFunctionBuilder;

public class InstanceFunctionBuilder
implements MemberFunctionBuilder {
    private final Constraint constraint;
    private final Signature signature;
    private final Statement statement;
    private final String name;
    private final int modifiers;

    public InstanceFunctionBuilder(Signature signature, Statement statement, Constraint constraint, String name, int modifiers) {
        this.constraint = constraint;
        this.modifiers = modifiers;
        this.signature = signature;
        this.statement = statement;
        this.name = name;
    }

    @Override
    public FunctionBody create(TypeBody body, Scope scope, Type type) {
        StatementInvocationBuilder builder = new StatementInvocationBuilder(this.signature, this.statement, this.constraint, type);
        InstanceInvocation invocation = new InstanceInvocation(builder, this.name, this.statement == null);
        InvocationFunction function = new InvocationFunction(this.signature, invocation, type, this.constraint, this.name, this.modifiers);
        if (!ModifierType.isAbstract(this.modifiers) && this.statement == null) {
            throw new InternalStateException("Function '" + function + "' is not abstract");
        }
        return new FunctionBody(builder, null, function);
    }
}

