/*
 * Decompiled with CFR 0.152.
 */
package org.snapscript.tree.define;

import org.snapscript.core.Evaluation;
import org.snapscript.core.constraint.Constraint;
import org.snapscript.core.error.InternalStateException;
import org.snapscript.core.scope.Scope;
import org.snapscript.core.scope.State;
import org.snapscript.core.type.TypeState;
import org.snapscript.core.variable.Value;
import org.snapscript.tree.DeclarationAllocator;
import org.snapscript.tree.ModifierChecker;
import org.snapscript.tree.ModifierData;
import org.snapscript.tree.define.InstanceField;
import org.snapscript.tree.define.MemberFieldAllocator;
import org.snapscript.tree.define.MemberFieldData;
import org.snapscript.tree.define.StaticField;

public class MemberFieldAssembler {
    private final ModifierChecker checker;

    public MemberFieldAssembler(ModifierData modifiers) {
        this.checker = new ModifierChecker(modifiers);
    }

    public TypeState assemble(MemberFieldData data) throws Exception {
        Evaluation declaration = this.create(data);
        if (this.checker.isStatic()) {
            return new StaticField(declaration);
        }
        return new InstanceField(declaration);
    }

    private Evaluation create(MemberFieldData data) throws Exception {
        int modifiers = this.checker.getModifiers();
        String name = data.getName();
        Constraint constraint = data.getConstraint();
        Evaluation declare = data.getValue();
        return new Declaration(name, constraint, declare, modifiers);
    }

    private static class Declaration
    extends Evaluation {
        private final DeclarationAllocator allocator;
        private final Constraint constraint;
        private final Evaluation declare;
        private final String name;
        private final int modifiers;

        public Declaration(String name, Constraint constraint, Evaluation declare, int modifiers) {
            this.allocator = new MemberFieldAllocator(constraint, declare);
            this.constraint = constraint;
            this.modifiers = modifiers;
            this.declare = declare;
            this.name = name;
        }

        @Override
        public void define(Scope scope) throws Exception {
            if (this.declare != null) {
                this.declare.define(scope);
            }
        }

        @Override
        public Constraint compile(Scope scope, Constraint left) throws Exception {
            Object value = this.allocator.compile(scope, this.name, this.modifiers);
            State state = scope.getState();
            try {
                state.addValue(this.name, (Value)value);
            }
            catch (Exception e) {
                throw new InternalStateException("Declaration of variable '" + this.name + "' failed", e);
            }
            return this.constraint;
        }

        @Override
        public Value evaluate(Scope scope, Value left) throws Exception {
            Object value = this.allocator.allocate(scope, this.name, this.modifiers);
            State state = scope.getState();
            try {
                state.addValue(this.name, (Value)value);
            }
            catch (Exception e) {
                throw new InternalStateException("Declaration of variable '" + this.name + "' failed", e);
            }
            return value;
        }
    }
}

